/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.controls;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BreachingWaterBoundPathNavigation
extends PathNavigation {
    private boolean allowBreaching;

    public BreachingWaterBoundPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.allowBreaching = true;
        this.nodeEvaluator = new SwimNodeEvaluator(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.isInLiquid();
    }

    @NotNull
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    protected double getGroundY(Vec3 vec) {
        return vec.y;
    }

    protected boolean canMoveDirectly(@NotNull Vec3 posVec31, @NotNull Vec3 posVec32) {
        return BreachingWaterBoundPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)posVec31, (Vec3)posVec32, (boolean)false);
    }

    public boolean isStableDestination(@NotNull BlockPos pos) {
        return !this.level.getBlockState(pos).isSolidRender((BlockGetter)this.level, pos);
    }

    public void setCanFloat(boolean canSwim) {
    }
}

