/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.eagle;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;

public final class EagleAttackEntitySensor
extends NearestLivingEntitySensor<EagleEntity> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull EagleEntity eagle) {
        super.doTick(level, (LivingEntity)eagle);
        if (eagle.isTame()) {
            eagle.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> {
                EagleEntity eagle2;
                if (eagle.isBaby()) {
                    EagleEntity eagle22;
                    return Sensor.isEntityAttackable((LivingEntity)eagle, (LivingEntity)target) && eagle.getOwner() != null && (eagle.getOwner().getLastHurtByMob() == target || eagle.getOwner().getLastHurtMob() == target && eagle.isFollowing()) && (!(target instanceof EagleEntity) || (eagle22 = (EagleEntity)target).getOwner() == null || eagle22.getOwner() != eagle.getOwner()) && eagle.canBabyAttack((Entity)target);
                }
                return Sensor.isEntityAttackable((LivingEntity)eagle, (LivingEntity)target) && eagle.getOwner() != null && (eagle.getOwner().getLastHurtByMob() == target || eagle.getOwner().getLastHurtMob() == target && eagle.isFollowing()) && (!(target instanceof EagleEntity) || (eagle2 = (EagleEntity)target).getOwner() == null || eagle2.getOwner() != eagle.getOwner());
            }).findFirst().ifPresentOrElse(ent -> eagle.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> eagle.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
        } else {
            eagle.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> {
                if (eagle.isBaby()) {
                    return Sensor.isEntityAttackable((LivingEntity)eagle, (LivingEntity)target) && eagle.canAttack((LivingEntity)target) && eagle.canBabyAttack((Entity)target) && eagle.distanceToSqr((Entity)target) < 9.0;
                }
                return Sensor.isEntityAttackable((LivingEntity)eagle, (LivingEntity)target) && eagle.canAttack((LivingEntity)target);
            }).findFirst().ifPresentOrElse(ent -> eagle.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> eagle.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
        }
    }

    protected int radiusXZ() {
        return 48;
    }

    protected int radiusY() {
        return 48;
    }
}

