/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.primal.advancements.criterion.SharkKillsEntity;
import org.primal.client.animation.entity.SharkAnimations;
import org.primal.entity.ai.SharkAi;
import org.primal.entity.ai.controls.BreachingWaterBoundPathNavigation;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.MiscUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SharkEntity
extends WaterAnimal
implements VariantHolder<Variant>,
GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_JOCKEY = SynchedEntityData.defineId(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static int AirSupplyWhenBeached = 1200;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.4f);
    }

    public SharkEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.setHealth(this.getMaxHealth());
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Holder holder = level.getBiome(this.blockPosition());
        if (holder.is(Primal_Tags.SPAWNS_TIGER_SHARK)) {
            this.setVariant(Variant.TIGER);
        } else if (holder.is(Primal_Tags.SPAWNS_HAMMERHEAD)) {
            this.setVariant(Variant.HAMMERHEAD);
        } else {
            this.setVariant(Variant.GREAT_WHITE);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(SharkAnimations.mainController(this).receiveTriggeredAnimations());
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void tick() {
        super.tick();
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
        }
        if (this.onGround() && !this.isInWater() && !this.isDeadOrDying() && !this.shouldBeBeached()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)Variant.GREAT_WHITE.id);
        builder.define(IS_JOCKEY, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().id);
        compound.putBoolean("SharkJockey", this.isSharkJockey());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
        this.setSharkJockey(compound.getBoolean("SharkJockey"));
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    public @NotNull Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public boolean isSharkJockey() {
        return (Boolean)this.entityData.get(IS_JOCKEY);
    }

    public void setSharkJockey(boolean isJockey) {
        this.entityData.set(IS_JOCKEY, (Object)isJockey);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        return new BreachingWaterBoundPathNavigation((Mob)this, level);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        Brain<SharkEntity> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        this.setSprinting(brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent());
        SharkAi.updateActivity(this);
        if (this.isSharkJockey() && this.shouldBeBeached()) {
            this.ejectPassengers();
        }
        if (this.isSharkJockey() && !this.isVehicle()) {
            this.setSharkJockey(false);
        }
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public float getSpeed() {
        return this.isSprinting() ? super.getSpeed() * 1.3f : super.getSpeed();
    }

    protected void registerGoals() {
    }

    @NotNull
    protected Brain.Provider<SharkEntity> brainProvider() {
        return SharkAi.brainProvider();
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        return SharkAi.makeBrain((Brain<SharkEntity>)this.brainProvider().makeBrain(dynamic));
    }

    @NotNull
    public Brain<SharkEntity> getBrain() {
        return super.getBrain();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean canAttack(@NotNull LivingEntity target) {
        return super.canAttack(target) && this.isInWater() && (target.getHealth() < target.getMaxHealth() && !(target instanceof SharkEntity) || !this.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && target.getType().is(Primal_Tags.SHARK_HUNTABLE) || this.getLastHurtByMob() == target || this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()) && (((LivingEntity)this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()).get()).getLastHurtMob() == target || ((LivingEntity)this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()).get()).getLastHurtByMob() == target)) && !target.hasEffect(MobEffects.CONDUIT_POWER) && MiscUtil.isNotNeverAttack(target);
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        List playersList;
        if (killed.getType().is(Primal_Tags.SHARK_HUNTABLE)) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 600L);
        }
        if (Primal_Advancements.ANIMALS_SHARK_NEEDS_TO_KILL.contains(killed.getType()) && !(playersList = this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(24.0))).isEmpty()) {
            playersList.forEach(player -> ((SharkKillsEntity)((Object)((Object)Primal_Advancements.FEED_SHARK.get()))).trigger((ServerPlayer)player, killed));
        }
        return super.killedEntity(level, killed);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Entity entity;
        boolean hurt = super.hurt(source, amount);
        if (this.level().isClientSide) {
            return false;
        }
        if (hurt && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            SharkAi.wasHurtBy(this, target);
        }
        return hurt;
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (this.getRandom().nextIntBetweenInclusive(0, 100) < 5) {
            ItemStack toothStack = new ItemStack(Primal_Items.SHARK_TOOTH, this.getRandom().nextBoolean() ? 2 : 1);
            this.spawnAtLocation(toothStack);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)this.getRandom().nextIntBetweenInclusive(20, 100));
        }
        return hurt;
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            double y = this.getY() + 0.2;
            float bodyYawRad = this.yBodyRot * ((float)Math.PI / 180);
            double forwardOffset = -0.8;
            double sideOffset = -0.0;
            double x = this.getX() + (double)Mth.sin((float)bodyYawRad) * forwardOffset + (double)Mth.cos((float)bodyYawRad) * sideOffset;
            double z = this.getZ() - (double)Mth.cos((float)bodyYawRad) * forwardOffset + (double)Mth.sin((float)bodyYawRad) * sideOffset;
            callback.accept(passenger, x, y, z);
        }
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)Primal_Sounds.SHARK_FLOP.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)Primal_Sounds.SHARK_IDLE.get();
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    protected void playAttackSound() {
        this.playSound((SoundEvent)Primal_Sounds.SHARK_ATTACK.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.SHARK_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)Primal_Sounds.SHARK_DEATH.get();
    }

    public boolean shouldBeBeached() {
        return this.getAirSupply() <= AirSupplyWhenBeached;
    }

    public int getMaxAirSupply() {
        return 2400;
    }

    protected void handleAirSupply(int airSupply) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(airSupply - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(this.getMaxAirSupply());
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.isSharkJockey();
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum Variant implements StringRepresentable
    {
        GREAT_WHITE(0, "great_white"),
        HAMMERHEAD(1, "hammerhead"),
        TIGER(2, "tiger");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

