/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public class BearBeg
extends Behavior<BearEntity> {
    private Player player;

    public BearBeg() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, @NotNull BearEntity bear) {
        this.player = level.m_45946_(TargetingConditions.m_148353_().m_26883_(3.5), (LivingEntity)bear);
        return this.player != null && !bear.bearCollapses() && !bear.isBearSleeping() && (BearEntity.isTameFood(this.player.m_21205_()) && !bear.m_21824_() || BearEntity.isHealFood(this.player.m_21205_()) && bear.m_21223_() < bear.m_21233_() && bear.m_21824_() || BearEntity.isMatingFood(this.player.m_21205_()) && !bear.m_6162_() && bear.m_5957_() && bear.m_146764_() == 0);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        return this.checkExtraStartConditions(level, bear) && this.m_22543_((LivingEntity)bear);
    }

    protected void tick(@NotNull ServerLevel level, BearEntity owner, long gameTime) {
        Brain<BearEntity> brain = owner.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26370_);
        BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)this.player);
    }

    protected void start(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        bear.stopMoving();
        bear.m_20124_(Pose.SNIFFING);
    }

    protected void stop(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "beg_end");
        entity.m_20124_(Pose.STANDING);
    }
}

