/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.crocodile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class CrocodileStartAttack
extends Behavior<CrocodileEntity> {
    private final int cooldownBetweenAttacks;

    public CrocodileStartAttack(int cooldownBetweenAttacks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148194_, (Object)MemoryStatus.VALUE_PRESENT));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile) {
        LivingEntity target = (LivingEntity)crocodile.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        NearestVisibleLivingEntities nearestVisibleLivingEntities = (NearestVisibleLivingEntities)crocodile.m_6274_().m_21952_(MemoryModuleType.f_148205_).get();
        return !CrocodileStartAttack.isHoldingUsableProjectileWeapon((Mob)crocodile) && crocodile.m_217066_(target) && nearestVisibleLivingEntities.m_186107_(target) && crocodile.m_20197_().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        LivingEntity target = (LivingEntity)crocodile.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        crocodile.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
        crocodile.m_6674_(InteractionHand.MAIN_HAND);
        if (CrocodileEntity.canPickUpEntity((Entity)target, crocodile)) {
            target.m_20329_((Entity)crocodile);
            crocodile.setHealthWhenStartRiding(crocodile.m_21223_());
            crocodile.m_20124_(Pose.SPIN_ATTACK);
            crocodile.m_6274_().m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get(), (Object)true);
            this.stop(level, crocodile, gameTime);
        } else {
            crocodile.m_7327_((Entity)target);
            this.stop(level, crocodile, gameTime);
        }
    }

    protected void tick(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        crocodile.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)this.cooldownBetweenAttacks);
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.m_21093_(stack -> {
            Item item = stack.m_41720_();
            return item instanceof ProjectileWeaponItem && mob.m_5886_((ProjectileWeaponItem)item);
        });
    }
}

