/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene90.blocktree;

import guideme.internal.shaded.lucene.codecs.lucene90.blocktree.IntersectTermsEnum;
import guideme.internal.shaded.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import guideme.internal.shaded.lucene.codecs.lucene90.blocktree.SegmentTermsEnum;
import guideme.internal.shaded.lucene.codecs.lucene90.blocktree.Stats;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.store.ByteArrayDataInput;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import guideme.internal.shaded.lucene.util.fst.ByteSequenceOutputs;
import guideme.internal.shaded.lucene.util.fst.FST;
import guideme.internal.shaded.lucene.util.fst.OffHeapFSTStore;
import java.io.IOException;

public final class FieldReader
extends Terms {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long rootBlockFP;
    final BytesRef rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final Lucene90BlockTreeTermsReader parent;
    final FST<BytesRef> index;

    FieldReader(Lucene90BlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, BytesRef rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, IndexInput metaIn, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = this.readVLongOutput(new ByteArrayDataInput(rootCode.bytes, rootCode.offset, rootCode.length)) >>> 2;
        FST.FSTMetadata<BytesRef> metadata = FST.readMetadata(metaIn, ByteSequenceOutputs.getSingleton());
        this.index = FST.fromFSTReader(metadata, new OffHeapFSTStore(indexIn, indexStartFP, metadata));
        BytesRef emptyOutput = metadata.getEmptyOutput();
        if (!rootCode.equals(emptyOutput)) {
            assert (false);
            this.rootCode = rootCode;
        } else {
            this.rootCode = emptyOutput;
        }
    }

    long readVLongOutput(DataInput in) throws IOException {
        if (this.parent.version >= 1) {
            return FieldReader.readMSBVLong(in);
        }
        return in.readVLong();
    }

    static long readMSBVLong(DataInput in) throws IOException {
        byte b;
        long l = 0L;
        do {
            b = in.readByte();
            l = l << 7 | (long)b & 0x7FL;
        } while ((b & 0x80) != 0);
        return l;
    }

    @Override
    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    @Override
    public Stats getStats() throws IOException {
        return new SegmentTermsEnum(this).computeBlockStats();
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this);
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new IntersectTermsEnum(this, compiled.getTransitionAccessor(), compiled.getByteRunnable(), compiled.commonSuffixRef, startTerm);
    }

    public String toString() {
        return "BlockTreeTerms(seg=" + this.parent.segment + " terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

