/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesRangeQuery;
import guideme.internal.shaded.lucene.document.SortedNumericDocValuesSetQuery;
import guideme.internal.shaded.lucene.index.DocValuesSkipIndexType;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.search.Query;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();
    private static final FieldType INDEXED_TYPE;

    public static SortedNumericDocValuesField indexedField(String name, long value) {
        return new SortedNumericDocValuesField(name, value, INDEXED_TYPE);
    }

    public SortedNumericDocValuesField(String name, long value) {
        this(name, value, TYPE);
    }

    private SortedNumericDocValuesField(String name, Long value, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue);
    }

    public static Query newSlowSetQuery(String field, long ... values) {
        return new SortedNumericDocValuesSetQuery(field, (long[])values.clone());
    }

    public static Query newSlowExactQuery(String field, long value) {
        return SortedNumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
        INDEXED_TYPE = new FieldType(TYPE);
        INDEXED_TYPE.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
        INDEXED_TYPE.freeze();
    }
}

