/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.LeafFieldComparator;
import guideme.internal.shaded.lucene.search.Scorable;
import java.io.IOException;

final class MultiLeafFieldComparator
implements LeafFieldComparator {
    private final LeafFieldComparator[] comparators;
    private final int[] reverseMul;
    private final LeafFieldComparator firstComparator;
    private final int firstReverseMul;

    MultiLeafFieldComparator(LeafFieldComparator[] comparators, int[] reverseMul) {
        if (comparators.length != reverseMul.length) {
            throw new IllegalArgumentException("Must have the same number of comparators and reverseMul, got " + comparators.length + " and " + reverseMul.length);
        }
        this.comparators = comparators;
        this.reverseMul = reverseMul;
        this.firstComparator = comparators[0];
        this.firstReverseMul = reverseMul[0];
    }

    @Override
    public void setBottom(int slot) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setBottom(slot);
        }
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareBottom(doc);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareBottom(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compareTop(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareTop(doc);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 1; i < this.comparators.length; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareTop(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.copy(slot, doc);
        }
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        for (LeafFieldComparator comparator : this.comparators) {
            comparator.setScorer(scorer);
        }
    }

    @Override
    public void setHitsThresholdReached() throws IOException {
        this.firstComparator.setHitsThresholdReached();
    }

    @Override
    public DocIdSetIterator competitiveIterator() throws IOException {
        return this.firstComparator.competitiveIterator();
    }
}

