/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.api.energy.CableTier;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import org.jetbrains.annotations.ApiStatus;

public interface MIEnergyStorage
extends ILongEnergyStorage {
    public boolean canConnect(CableTier var1);

    @ApiStatus.NonExtendable
    default public boolean canConnect(String cableTier) {
        return switch (cableTier) {
            case "lv" -> this.canConnect(CableTier.LV);
            case "mv" -> this.canConnect(CableTier.MV);
            case "hv" -> this.canConnect(CableTier.HV);
            case "ev" -> this.canConnect(CableTier.EV);
            case "superconductor" -> this.canConnect(CableTier.SUPERCONDUCTOR);
            default -> false;
        };
    }

    public static interface NoInsert
    extends MIEnergyStorage {
        default public boolean canReceive() {
            return false;
        }

        default public long receive(long amount, boolean simulate) {
            return 0L;
        }
    }

    public static interface NoExtract
    extends MIEnergyStorage {
        default public boolean canExtract() {
            return false;
        }

        default public long extract(long maxExtract, boolean simulate) {
            return 0L;
        }
    }
}

