/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.abstraction;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.util.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class ViewerCategory<D> {
    public final Class<D> dataClass;
    public final ResourceLocation id;
    public final Component title;
    public final Icon icon;
    public final int width;
    public final int height;

    protected ViewerCategory(Class<D> dataClass, ResourceLocation id, Component title, ItemStack icon, int width, int height) {
        this(dataClass, id, title, new Icon.Stack(icon), width, height);
    }

    protected ViewerCategory(Class<D> dataClass, ResourceLocation id, Component title, Icon icon, int width, int height) {
        this.dataClass = dataClass;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.width = width;
        this.height = height;
    }

    public abstract void buildWorkstations(WorkstationConsumer var1);

    public abstract void buildRecipes(RecipeManager var1, RegistryAccess var2, Consumer<D> var3);

    public abstract void buildLayout(D var1, LayoutBuilder var2);

    public abstract void buildWidgets(D var1, WidgetList var2);

    public abstract ResourceLocation getRecipeId(D var1);

    public static sealed interface Icon {

        public record Texture(ResourceLocation loc, int u, int v) implements Icon
        {
        }

        public record Stack(ItemStack stack) implements Icon
        {
        }
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static interface WidgetList {
        public void text(Component var1, float var2, float var3, TextAlign var4, boolean var5, boolean var6, @Nullable Component var7);

        default public void secondaryText(Component text, float x, float y) {
            this.text(text, x, y, TextAlign.LEFT, false, true, null);
        }

        public void arrow(int var1, int var2);

        public void texture(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7);

        default public void rectangle(Rectangle rectangle, int fillColor) {
            this.drawable(guiGraphics -> guiGraphics.fill(rectangle.x(), rectangle.y(), rectangle.x() + rectangle.w(), rectangle.y() + rectangle.h(), fillColor));
        }

        public void drawable(Consumer<GuiGraphics> var1);

        public void tooltip(int var1, int var2, int var3, int var4, List<Component> var5);

        public void scrollableSlots(int var1, int var2, List<ItemStack> var3);
    }

    public static interface SlotBuilder {
        public SlotBuilder variant(TransferVariant<?> var1);

        public SlotBuilder fluid(FluidVariant var1, long var2, float var4);

        public SlotBuilder fluid(FluidIngredient var1, long var2, float var4);

        default public SlotBuilder item(ItemStack stack) {
            return this.item(stack, 1.0f);
        }

        public SlotBuilder item(ItemStack var1, float var2);

        public SlotBuilder ingredient(Ingredient var1, long var2, float var4);

        public SlotBuilder removeBackground();

        public SlotBuilder markCatalyst();

        public static class NoOp
        implements SlotBuilder {
            @Override
            public SlotBuilder variant(TransferVariant<?> variant) {
                return this;
            }

            @Override
            public SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
                return this;
            }

            @Override
            public SlotBuilder fluid(FluidIngredient ingredient, long amount, float probability) {
                return this;
            }

            @Override
            public SlotBuilder item(ItemStack stack, float probability) {
                return this;
            }

            @Override
            public SlotBuilder ingredient(Ingredient ingredient, long amount, float probability) {
                return this;
            }

            @Override
            public SlotBuilder removeBackground() {
                return this;
            }

            @Override
            public SlotBuilder markCatalyst() {
                return this;
            }
        }
    }

    public static interface LayoutBuilder {
        public SlotBuilder inputSlot(int var1, int var2);

        public SlotBuilder outputSlot(int var1, int var2);

        public void invisibleInput(ItemStack var1);

        public void invisibleOutput(ItemStack var1);

        public void scrollableSlots(int var1, int var2, List<ItemStack> var3);
    }

    public static interface WorkstationConsumer {
        public void accept(ItemLike ... var1);

        default public void accept(String ... itemPath) {
            for (String item : itemPath) {
                this.accept((ItemLike)BuiltInRegistries.ITEM.get(MI.id(item)));
            }
        }
    }
}

