/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.config.MIClientConfig;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.armor.GraviChestPlateItem;
import aztech.modern_industrialization.items.armor.JetpackItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HudRenderer {
    public static void onRenderHud(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, (float)MIClientConfig.INSTANCE.armorHudYPosition.getAsInt(), 0.0f);
            ItemStack chest = mc.player.getItemBySlot(EquipmentSlot.CHEST);
            Item item = chest.getItem();
            if (item instanceof JetpackItem) {
                JetpackItem jetpack = (JetpackItem)item;
                boolean active = jetpack.isActivated(chest);
                MutableComponent jetpackActiveComponent = active ? MIText.JetpackEnabled.text().setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)) : MIText.JetpackDisabled.text().setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                guiGraphics.drawString(mc.font, (Component)jetpackActiveComponent, 4, 0, 0xF9FFFE);
                MutableComponent fillText = MIText.JetpackFill.text(FluidFuelItemHelper.getAmount(chest) * 100 / 8000);
                guiGraphics.drawString(mc.font, (Component)fillText, 4, 10, 0xF9FFFE);
            } else {
                Item active = chest.getItem();
                if (active instanceof GraviChestPlateItem) {
                    GraviChestPlateItem gsp = (GraviChestPlateItem)active;
                    boolean active2 = gsp.isActivated(chest);
                    MutableComponent gravichestplateActiveComponent = active2 ? MIText.GravichestplateEnabled.text().setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)) : MIText.GravichestplateDisabled.text().setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                    guiGraphics.drawString(mc.font, (Component)gravichestplateActiveComponent, 4, 0, 0xF9FFFE);
                    MutableComponent fillText = MIText.EnergyFill.text(gsp.getEnergy(chest) * 100L / 0x1000000L);
                    guiGraphics.drawString(mc.font, (Component)fillText, 4, 10, 0xF9FFFE);
                }
            }
            guiGraphics.pose().popPose();
        }
    }
}

