/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.config.MIClientConfig;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockErrorHighlight;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class MultiblockMachineBER
extends MachineBlockEntityRenderer<MultiblockMachineBlockEntity> {
    private static final double MAX_HIGHLIGHT_DISTANCE = 32.0;

    public MultiblockMachineBER(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    public void render(MultiblockMachineBlockEntity be, float tickDelta, PoseStack matrices, MultiBufferSource vcp, int light, int overlay) {
        super.render(be, tickDelta, matrices, vcp, light, overlay);
        boolean drawHighlights = MultiblockMachineBER.isHoldingWrench() && !be.isShapeValid();
        HatchType hatchType = MultiblockMachineBER.getHeldHatchType();
        if (drawHighlights || hatchType != null) {
            ShapeMatcher matcher = be.createShapeMatcher();
            LocalPlayer player = Minecraft.getInstance().player;
            for (BlockPos pos : matcher.getPositions()) {
                if (player != null && player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > 1024.0) continue;
                matrices.pushPose();
                matrices.translate((float)(pos.getX() - be.getBlockPos().getX()), (float)(pos.getY() - be.getBlockPos().getY()), (float)(pos.getZ() - be.getBlockPos().getZ()));
                HatchFlags hatchFlag = matcher.getHatchFlags(pos);
                if (hatchType != null && MIClientConfig.INSTANCE.hatchPlacementOverlay.getAsBoolean() && hatchFlag != null && hatchFlag.allows(hatchType)) {
                    matrices.translate(-0.005, -0.005, -0.005);
                    matrices.scale(1.01f, 1.01f, 1.01f);
                    RenderHelper.drawOverlay(matrices, vcp, overlay);
                }
                if (drawHighlights && !matcher.matches(pos, be.getLevel(), null)) {
                    BlockState existingState = be.getLevel().getBlockState(pos);
                    if (existingState.isAir() || existingState.canBeReplaced()) {
                        MultiblockErrorHighlight.enqueueHighlight(pos, matcher.getSimpleMember(pos).getPreviewState());
                    } else {
                        MultiblockErrorHighlight.enqueueHighlight(pos, null);
                    }
                }
                matrices.popPose();
            }
        }
    }

    private static boolean isHoldingWrench() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player.getMainHandItem().is(MITags.WRENCHES) || player.getOffhandItem().is(MITags.WRENCHES);
    }

    @Nullable
    private static HatchType getHeldHatchType() {
        LocalPlayer player = Minecraft.getInstance().player;
        HatchType mainHand = MultiblockMachineBER.getHatchType(player.getMainHandItem());
        HatchType offHand = MultiblockMachineBER.getHatchType(player.getOffhandItem());
        return mainHand == null ? offHand : mainHand;
    }

    @Nullable
    private static HatchType getHatchType(ItemStack stack) {
        MachineBlock block;
        MachineBlockEntity be;
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof MachineBlock && (be = (block = (MachineBlock)blockItem.getBlock()).newBlockEntity(new BlockPos(0, 0, 0), block.defaultBlockState())) instanceof HatchBlockEntity) {
            HatchBlockEntity hatch = (HatchBlockEntity)be;
            return hatch.getHatchType();
        }
        return null;
    }

    public boolean shouldRenderOffScreen(MultiblockMachineBlockEntity pBlockEntity) {
        return true;
    }

    public AABB getRenderBoundingBox(MultiblockMachineBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

