/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialItemPartImpl;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public sealed interface MaterialItemPart
extends PartKeyProvider,
ItemLike
permits MaterialItemPartImpl {
    public static MaterialItemPart external(PartKey key, String taggedItemId, String itemId) {
        return new MaterialItemPartImpl(key, taggedItemId, itemId, ctx -> {}, new TextureGenParams.NoTexture(), false);
    }

    public static MaterialItemPart external(PartKeyProvider part, String taggedItemId, String itemId) {
        return MaterialItemPart.external(part.key(), taggedItemId, itemId);
    }

    public static MaterialItemPart external(PartKeyProvider part, String itemId) {
        return MaterialItemPart.external(part, itemId, itemId);
    }

    public static MaterialItemPart simpleItem(PartKeyProvider part, String englishName, String itemPath) {
        String itemId = "modern_industrialization:" + itemPath;
        return new MaterialItemPartImpl(part.key(), itemId, itemId, ctx -> MIItem.item(englishName, itemPath, SortOrder.MATERIALS.and((Comparable)((Object)ctx.getMaterialName()))), new TextureGenParams.NoTexture(), true);
    }

    public String getTaggedItemId();

    default public Ingredient getTaggedIngredient() {
        String taggedItem = this.getTaggedItemId();
        if (taggedItem.startsWith("#")) {
            return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)taggedItem.substring(1))));
        }
        return Ingredient.of((ItemLike[])new ItemLike[]{this.asItem()});
    }

    public String getItemId();

    default public Item asItem() {
        return (Item)BuiltInRegistries.ITEM.getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)this.getItemId())));
    }

    default public Block asBlock() {
        return (Block)BuiltInRegistries.BLOCK.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)this.getItemId())));
    }

    public void register(MaterialBuilder.PartContext var1);

    public TextureGenParams getTextureGenParams();

    public boolean isInternal();
}

