/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;

public class RotatedModelHelper {
    public static final ModelState[] PIPE_BAKE_SETTINGS = new ModelState[]{RotatedModelHelper.preRotated(BlockModelRotation.X90_Y0, 270.0f), BlockModelRotation.X270_Y0, BlockModelRotation.X0_Y0, RotatedModelHelper.preRotated(BlockModelRotation.X0_Y180, 90.0f), RotatedModelHelper.preRotated(BlockModelRotation.X0_Y270, 90.0f), BlockModelRotation.X0_Y90};

    public static ModelState preRotated(BlockModelRotation rotation, float preAngle) {
        Transformation preRotation = new Transformation(null, Axis.ZP.rotationDegrees(preAngle), null, null);
        final Transformation combined = rotation.getRotation().compose(preRotation);
        return new ModelState(){

            public Transformation getRotation() {
                return combined;
            }
        };
    }

    public static BakedModel[] loadRotatedModels(ResourceLocation modelId, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter) {
        BakedModel[] models = new BakedModel[6];
        for (int i = 0; i < 6; ++i) {
            models[i] = modelBaker.bake(modelId, PIPE_BAKE_SETTINGS[i], spriteGetter);
        }
        return models;
    }
}

