/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator;

import com.google.gson.GsonBuilder;
import io.github.raverbury.aggroindicator.Constants;
import io.github.raverbury.aggroindicator.platform.Services;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;

public class ClientConfig {
    private static final File CONFIG_FILE = new File(Services.CONFIG_HELPER.getConfigSavePath().toFile(), "aggroindicator-client.json");
    private static final float[] cachedColors = new float[]{1.0f, 0.0f, 0.0f};
    private static ClientConfig CACHED_CONFIG = null;
    private static HashSet<String> CACHED_BLACKLIST_TABLE = null;
    public boolean renderAlertIcon = true;
    public boolean scaleWithMobSize = true;
    public List<String> mobBlacklist = List.of("minecraft:bat");
    public boolean treatBlacklistAsWhitelist = false;
    public int alertIconStyle = 0;
    private float renderRange = 24.0f;
    private float xOffset = 0.0f;
    private float yOffset = 10.0f;
    private float alertIconSize = 30.0f;
    private String alertColorHex = "0xFF6666";
    private int hideAlertAfterTicks = 0;

    public static ClientConfig cachedOrDefault() {
        if (CACHED_CONFIG != null) {
            return CACHED_CONFIG;
        }
        return new ClientConfig();
    }

    public static ClientConfig loadOrDefault() {
        ClientConfig config;
        if (!CONFIG_FILE.exists()) {
            ClientConfig.save(new ClientConfig());
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());){
            config = (ClientConfig)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, ClientConfig.class);
        }
        catch (IOException e) {
            Constants.LOG.error("[Aggro Indicator] Loading config failed: {}, using default value.", (Object)e.getMessage(), (Object)e);
            config = new ClientConfig();
        }
        CACHED_BLACKLIST_TABLE = null;
        Color alertColor = Color.decode(config.alertColorHex);
        ClientConfig.cachedColors[0] = (float)alertColor.getRed() / 255.0f;
        ClientConfig.cachedColors[1] = (float)alertColor.getGreen() / 255.0f;
        ClientConfig.cachedColors[2] = (float)alertColor.getBlue() / 255.0f;
        CACHED_CONFIG = config;
        return config;
    }

    public static void save(ClientConfig clientConfig) {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)clientConfig, (Appendable)writer);
        }
        catch (IOException e) {
            Constants.LOG.error("[Aggro Indicator] Saving config failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public float getClampedRenderRange() {
        return Math.min(32.0f, Math.max(this.renderRange, 0.0f));
    }

    public float getClampedXOffset() {
        return Math.min(30.0f, Math.max(this.xOffset, -30.0f));
    }

    public float getClampedYOffset() {
        return Math.min(50.0f, Math.max(this.yOffset, -50.0f));
    }

    public float getClampedAlertIconSize() {
        return Math.min(100.0f, Math.max(this.alertIconSize, 10.0f));
    }

    public HashSet<String> getBlacklistLookupTable() {
        if (CACHED_BLACKLIST_TABLE != null) {
            return CACHED_BLACKLIST_TABLE;
        }
        CACHED_BLACKLIST_TABLE = new HashSet<String>(this.mobBlacklist);
        return CACHED_BLACKLIST_TABLE;
    }

    public float[] getColors() {
        return cachedColors;
    }

    public int getHideTimer() {
        return Math.max(0, this.hideAlertAfterTicks);
    }
}

