/*
 * Decompiled with CFR 0.152.
 */
package net.berber.berbersbrews.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.berber.berbersbrews.effect.ModEffects;
import net.berber.berbersbrews.fishing.EarlyLootStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1536;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1536.class})
public abstract class FishingMixin
extends class_1297
implements EarlyLootStorage {
    @Shadow
    private int field_7173;
    @Shadow
    private int field_7172;
    @Unique
    private List<class_1799> earlyLoot = List.of();
    @Unique
    boolean flag = false;
    @Unique
    int i;
    @Unique
    int cycle;
    @Unique
    int deployCounter = 0;

    @Shadow
    @Nullable
    public abstract class_1657 method_6947();

    @Override
    public void berbers_brews$setEarlyLoot(List<class_1799> loot) {
        this.earlyLoot = loot;
    }

    @Override
    public List<class_1799> berbers_brews$getEarlyLoot() {
        return this.earlyLoot;
    }

    @Override
    public boolean berbers_brews$hasEarlyLoot() {
        return !this.earlyLoot.isEmpty();
    }

    public FishingMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tickFishingLogic"}, at={@At(value="HEAD")})
    private void onFishingTick(CallbackInfo ci) {
        FishingMixin lootStorage;
        FishingMixin fishingMixin = this;
        if (fishingMixin instanceof EarlyLootStorage && !(lootStorage = fishingMixin).berbers_brews$hasEarlyLoot() && !this.method_37908().field_9236) {
            this.generateLootEarly((class_1536)this, lootStorage);
        }
        if ((fishingMixin = this) instanceof EarlyLootStorage && (lootStorage = fishingMixin).berbers_brews$hasEarlyLoot() && this.method_6947() != null) {
            ++this.cycle;
            if (this.cycle > 20) {
                ++this.i;
                ++this.deployCounter;
                this.cycle = 0;
            }
            if (this.i >= lootStorage.berbers_brews$getEarlyLoot().size()) {
                this.i = 0;
            }
            this.method_5665((class_2561)class_2561.method_43470((String)lootStorage.berbers_brews$getEarlyLoot().get(this.i).method_7964().getString()));
            if (this.method_6947().method_6059(ModEffects.SONAR)) {
                if (this.field_7172 > 0 || this.field_7173 > 0 || this.deployCounter > 4) {
                    this.method_5880(true);
                }
            } else {
                this.method_5880(false);
            }
        }
        if (this.field_7173 <= 0) {
            fishingMixin = this;
            if (fishingMixin instanceof EarlyLootStorage) {
                lootStorage = fishingMixin;
                if (!this.flag) {
                    this.generateLootEarly((class_1536)this, lootStorage);
                    this.deployCounter = 0;
                    this.method_5880(false);
                    this.flag = true;
                }
            }
        } else {
            this.flag = false;
        }
    }

    @Unique
    private void generateLootEarly(class_1536 bobber, EarlyLootStorage lootStorage) {
        class_3218 world = (class_3218)bobber.method_37908();
        class_3222 player = (class_3222)bobber.method_6947();
        if (player == null) {
            return;
        }
        class_1799 tool = player.method_6047();
        if (!(tool.method_7909() instanceof class_1787)) {
            tool = player.method_6079();
        }
        class_8567.class_8568 paramBuilder = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)bobber.method_19538()).method_51874(class_181.field_1229, (Object)tool).method_51874(class_181.field_1226, (Object)bobber).method_51871(player.method_7292());
        class_8567 paramSet = paramBuilder.method_51875(class_173.field_1176);
        class_52 fishingLootTable = world.method_8503().method_58576().method_58295(class_39.field_353);
        ObjectArrayList drops = fishingLootTable.method_51878(paramSet);
        if (!drops.isEmpty()) {
            lootStorage.berbers_brews$setEarlyLoot(drops.stream().map(class_1799::method_7972).toList());
            this.method_5665((class_2561)class_2561.method_43470((String)lootStorage.berbers_brews$getEarlyLoot().get(0).method_7964().getString()));
        }
    }

    @ModifyArg(method={"use(Lnet/minecraft/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V"), index=4)
    private class_1799 replaceCaughtItem(class_1799 original) {
        EarlyLootStorage storage;
        class_1536 bobber = (class_1536)this;
        if (bobber instanceof EarlyLootStorage && (storage = (EarlyLootStorage)bobber).berbers_brews$hasEarlyLoot()) {
            List<class_1799> loot = storage.berbers_brews$getEarlyLoot();
            return loot.get(0).method_7972();
        }
        return original;
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z", shift=At.Shift.AFTER)})
    private void dropExtraLoot(class_1799 usedItem, CallbackInfoReturnable<Integer> cir) {
        EarlyLootStorage storage;
        class_1536 self = (class_1536)this;
        if (self instanceof EarlyLootStorage && (storage = (EarlyLootStorage)self).berbers_brews$hasEarlyLoot()) {
            List<class_1799> loot = storage.berbers_brews$getEarlyLoot();
            storage.berbers_brews$setEarlyLoot(List.of());
            for (int i = 1; i < loot.size(); ++i) {
                class_1542 extra = new class_1542(self.method_37908(), self.method_23317(), self.method_23318(), self.method_23321(), loot.get(i).method_7972());
                if (self.method_6947() != null) {
                    double dx = self.method_6947().method_23317() - self.method_23317();
                    double dy = self.method_6947().method_23320() - self.method_23318();
                    double dz = self.method_6947().method_23321() - self.method_23321();
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    double velocityFactor = 1.0;
                    extra.method_18800(dx / dist * velocityFactor, dy / dist * velocityFactor, dz / dist * velocityFactor);
                }
                self.method_37908().method_8649((class_1297)extra);
            }
        }
    }
}

