/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model.bedrock;

import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.geom.PartPose;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class BedrockPart {
    public final ObjectList<BedrockCube> cubes = new ObjectArrayList();
    private final List<BedrockPart> children = Lists.newArrayList();
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    public boolean mirror;
    public boolean emissive = false;

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int packedLight, int overlay) {
        this.render(poseStack, consumer, packedLight, overlay, -1);
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int packedLight, int overlay, int color) {
        if (this.visible) {
            this.renderCubes(false, poseStack, consumer, packedLight, overlay, color);
        }
    }

    public void renderEmissive(PoseStack poseStack, VertexConsumer consumer, int packedLight, int overlay) {
        this.renderEmissive(poseStack, consumer, packedLight, overlay, -1);
    }

    public void renderEmissive(PoseStack poseStack, VertexConsumer consumer, int packedLight, int overlay, int color) {
        if (this.visible) {
            this.renderCubes(true, poseStack, consumer, packedLight, overlay, color);
        }
    }

    public void renderCubes(boolean renderEmissive, PoseStack poseStack, VertexConsumer consumer, int packedLight, int overlay, int color) {
        if (!this.isEmpty()) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            if (this.emissive == renderEmissive) {
                this.compile(poseStack.last(), consumer, packedLight, overlay, color);
            }
            for (BedrockPart part : this.children) {
                if (renderEmissive) {
                    part.renderEmissive(poseStack, consumer, packedLight, overlay, color);
                    continue;
                }
                part.render(poseStack, consumer, packedLight, overlay, color);
            }
            poseStack.popPose();
        }
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.translate(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.mulPose(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
    }

    public void compile(PoseStack.Pose pose, VertexConsumer consumer, int packedLight, int overlay, int color) {
        for (BedrockCube bedrockCube : this.cubes) {
            bedrockCube.compile(pose, consumer, packedLight, overlay, color);
        }
    }

    public BedrockCube getRandomCube(Random random) {
        return (BedrockCube)this.cubes.get(random.nextInt(this.cubes.size()));
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public void setEmissive() {
        this.emissive = true;
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty() && this.children.isEmpty();
    }

    public PartPose storePose() {
        return PartPose.offsetAndRotation((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
    }

    public void loadPose(PartPose p_171323_) {
        this.x = p_171323_.x;
        this.y = p_171323_.y;
        this.z = p_171323_.z;
        this.xRot = p_171323_.xRot;
        this.yRot = p_171323_.yRot;
        this.zRot = p_171323_.zRot;
    }

    public void copyFrom(BedrockPart p_104316_) {
        this.xRot = p_104316_.xRot;
        this.yRot = p_104316_.yRot;
        this.zRot = p_104316_.zRot;
        this.x = p_104316_.x;
        this.y = p_104316_.y;
        this.z = p_104316_.z;
    }

    public void addChild(BedrockPart model) {
        if (this.isEmissive()) {
            model.setEmissive();
        }
        this.children.add(model);
    }

    public List<BedrockPart> getChildren() {
        return this.children;
    }
}

