/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class AbstractItemModelProvider
extends ItemModelProvider {
    private final String modid;

    public AbstractItemModelProvider(PackOutput generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
        this.modid = modid;
    }

    public void sign(Supplier<? extends SignBlock> sign) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(sign), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + this.blockName(sign)));
    }

    public void woodenFence(Supplier<? extends Block> fence, Supplier<? extends Block> block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)fence.get()).getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", "block/" + BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath());
    }

    public ItemModelBuilder torchItem(Supplier<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)item.get()).getPath()));
    }

    public ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        return this.buildItem(name, "item/generated", 0, layers);
    }

    public ItemModelBuilder buildItem(String name, String parent, int emissivity, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        if (emissivity > 0) {
            builder = (ItemModelBuilder)((ItemLayerModelBuilder)builder.customLoader(ItemLayerModelBuilder::begin)).emissive(emissivity, emissivity, new int[]{0}).renderType("minecraft:translucent", new int[]{0}).end();
        }
        return builder;
    }

    public ItemModelBuilder tool(String name, ResourceLocation ... layers) {
        return this.buildItem(name, "item/handheld", 0, layers);
    }

    public ItemModelBuilder singleTexTool(Supplier<? extends Item> item) {
        return this.tool(this.itemPath(item).getPath(), this.prefix("item/" + this.itemPath(item).getPath()));
    }

    public ItemModelBuilder singleTexRodTool(Supplier<? extends Item> item) {
        return this.toolRod(this.itemPath(item).getPath(), this.prefix("item/" + this.itemPath(item).getPath()));
    }

    public ItemModelBuilder toolRod(String name, ResourceLocation ... layers) {
        return this.buildItem(name, "item/handheld_rod", 0, layers);
    }

    public ItemModelBuilder singleTex(Supplier<? extends ItemLike> item) {
        return this.generated(this.itemPath(item).getPath(), this.prefix("item/" + this.itemPath(item).getPath()));
    }

    public ItemModelBuilder emmisiveTex(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)this.singleTex(item).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{0}).renderType("minecraft:translucent", new int[]{0}).end();
    }

    public ItemModelBuilder glowBowItem(Supplier<? extends Item> item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.get());
        this.buildItem(id.getPath() + "_pulling_0", this.mcLoc("item/bow").toString(), 15, this.modLoc("item/" + id.getPath() + "_pulling_0"));
        this.buildItem(id.getPath() + "_pulling_1", this.mcLoc("item/bow").toString(), 15, this.modLoc("item/" + id.getPath() + "_pulling_1"));
        this.buildItem(id.getPath() + "_pulling_2", this.mcLoc("item/bow").toString(), 15, this.modLoc("item/" + id.getPath() + "_pulling_2"));
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)this.withExistingParent(id.getPath(), this.mcLoc("item/bow"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{0}).renderType("minecraft:translucent", new int[]{0}).end()).texture("layer0", this.modLoc("item/" + id.getPath()))).override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_0"))).end().override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).predicate(ResourceLocation.parse((String)"pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_1"))).end().override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).predicate(ResourceLocation.parse((String)"pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_2"))).end();
    }

    public ItemModelBuilder bowItem(Supplier<? extends Item> item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.get());
        ((ItemModelBuilder)this.withExistingParent(id.getPath() + "_pulling_0", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + id.getPath() + "_pulling_0"));
        ((ItemModelBuilder)this.withExistingParent(id.getPath() + "_pulling_1", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + id.getPath() + "_pulling_1"));
        ((ItemModelBuilder)this.withExistingParent(id.getPath() + "_pulling_2", this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + id.getPath() + "_pulling_2"));
        return ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.getPath(), this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + id.getPath()))).override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_0"))).end().override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).predicate(ResourceLocation.parse((String)"pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_1"))).end().override().predicate(ResourceLocation.parse((String)"pulling"), 1.0f).predicate(ResourceLocation.parse((String)"pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + id.getPath() + "_pulling_2"))).end();
    }

    public void woodenButton(Supplier<? extends Block> button, String variant) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)button.get()).getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", "block/wood/planks_" + variant + "_0");
    }

    public void woodenFence(Block fence, String variant) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)fence).getPath())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", "block/wood/planks_" + variant + "_0");
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(BuiltInRegistries.BLOCK.getKey((Object)((Block)wall.get())).getPath(), this.texture(this.blockName(fullBlock)));
    }

    public ItemModelBuilder toBlock(Supplier<? extends Block> b) {
        return this.toBlockModel(b, BuiltInRegistries.BLOCK.getKey((Object)b.get()).getPath());
    }

    public ItemModelBuilder toBlockModel(Supplier<? extends Block> b, String model) {
        return this.toBlockModel(b, this.prefix("block/" + model));
    }

    public ItemModelBuilder toBlockModel(Supplier<? extends Block> b, ResourceLocation model) {
        return (ItemModelBuilder)this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)b.get()).getPath(), model);
    }

    public ItemModelBuilder itemBlockFlat(Supplier<? extends Block> block) {
        return this.itemBlockFlat(block, this.blockName(block));
    }

    public ItemModelBuilder itemBlockFlat(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + name));
    }

    public ItemModelBuilder egg(Supplier<Item> item) {
        return (ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/template_spawn_egg"));
    }

    public String blockName(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation itemPath(Supplier<? extends ItemLike> item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.get().asItem());
    }

    public String getModid() {
        return this.modid;
    }

    public ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModid(), (String)name.toLowerCase(Locale.ROOT));
    }
}

