/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.api;

import net.minecraft.core.Registry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.UmaSuitItem;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class UmapyoiAPI {
    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getRenderingUmaSoul(LivingEntity entity) {
        ICuriosItemHandler itemHandler;
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent() && (itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null)).getStacksHandler("uma_soul").isPresent()) {
            ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_soul").orElse(null);
            if (!((Boolean)stacksHandler.getRenders().get(0)).booleanValue()) {
                return ItemStack.EMPTY;
            }
            ItemStack cosmeticStack = UmapyoiAPI.getFirstUmaSoul(stacksHandler.getCosmeticStacks());
            if (!cosmeticStack.isEmpty()) {
                return cosmeticStack;
            }
            return UmapyoiAPI.getFirstUmaSoul(stacksHandler.getStacks());
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getUmaSoul(LivingEntity entity) {
        ICuriosItemHandler itemHandler;
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent() && (itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null)).getStacksHandler("uma_soul").isPresent()) {
            ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_soul").orElse(null);
            return UmapyoiAPI.getFirstUmaSoul(stacksHandler.getStacks());
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack getFirstUmaSoul(IDynamicStackHandler stackHandler) {
        if (stackHandler.getSlots() <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = stackHandler.getStackInSlot(0);
        if (stackInSlot.getItem() instanceof UmaSoulItem) {
            return stackInSlot;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getUmaSuit(LivingEntity entity) {
        ICuriosItemHandler itemHandler;
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent() && (itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null)).getStacksHandler("uma_suit").isPresent()) {
            ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_suit").orElse(null);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            if (stackHandler.getSlots() <= 0) {
                return ItemStack.EMPTY;
            }
            if (stackHandler.getStackInSlot(0).getItem() instanceof UmaSuitItem) {
                return stackHandler.getStackInSlot(0);
            }
        }
        return ItemStack.EMPTY;
    }

    public static boolean isUmaSuitRendering(LivingEntity player) {
        ICuriosItemHandler itemHandler;
        if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && (itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null)).getStacksHandler("uma_suit").isPresent()) {
            ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_suit").orElse(null);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            if (stackHandler.getSlots() <= 0) {
                return false;
            }
            if (stackHandler.getStackInSlot(0).getItem() instanceof UmaSuitItem) {
                return (Boolean)stacksHandler.getRenders().get(0);
            }
        }
        return false;
    }

    public static Registry<UmaData> getUmaDataRegistry(Level level) {
        if (level.isClientSide()) {
            return ClientUtils.getClientUmaDataRegistry();
        }
        return level.registryAccess().registryOrThrow(UmaData.REGISTRY_KEY);
    }

    public static Registry<SupportCard> getSupportCardRegistry(Level level) {
        if (level.isClientSide()) {
            return ClientUtils.getClientSupportCardRegistry();
        }
        return level.registryAccess().registryOrThrow(SupportCard.REGISTRY_KEY);
    }
}

