/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.entity.AbstractPedestalBlockEntity;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.block.entity.Gachable;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.inventory.CommonItemHandler;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.GachaUtils;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="umapyoi")
public class SilverSupportAlbumPedestalBlockEntity
extends AbstractPedestalBlockEntity
implements Gachable {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final Random RANDOM = new Random();
    public static final int MAX_PROCESS_TIME = 200;
    private final ItemStackHandler inventory = this.createHandler();
    private final IItemHandler inputHandler = new CommonItemHandler((IItemHandler)this.inventory, Direction.UP, 1, 0);
    private final IItemHandler outputHandler = new CommonItemHandler((IItemHandler)this.inventory, Direction.DOWN, 1, 0);
    protected final ContainerData tileData = this.createIntArray();
    private int recipeTime;
    private int animationTime;

    public int getProcessTime() {
        return this.recipeTime;
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public SilverSupportAlbumPedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SILVER_SUPPORT_ALBUM_PEDESTAL.get(), pos, state);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityRegistry.SILVER_SUPPORT_ALBUM_PEDESTAL.get(), (be, context) -> {
            if (context == Direction.UP) {
                return be.inputHandler;
            }
            return be.outputHandler;
        });
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, SilverSupportAlbumPedestalBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, SilverSupportAlbumPedestalBlockEntity blockEntity) {
        ++blockEntity.animationTime;
        if (blockEntity.canWork()) {
            ClientUtils.addSummonParticle(level, pos);
        }
        SilverSupportAlbumPedestalBlockEntity.bookAnimationTick(level, pos, state, blockEntity);
        blockEntity.animationTime %= 360;
    }

    private static void bookAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, SilverSupportAlbumPedestalBlockEntity pBlockEntity) {
        float f2;
        pBlockEntity.oOpen = pBlockEntity.open;
        pBlockEntity.oRot = pBlockEntity.rot;
        Player player = pLevel.getNearestPlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.getX() - ((double)pPos.getX() + 0.5);
            double d1 = player.getZ() - ((double)pPos.getZ() + 0.5);
            pBlockEntity.tRot = (float)Mth.atan2((double)d1, (double)d0);
        } else {
            pBlockEntity.tRot += 0.02f;
        }
        if (!pBlockEntity.isEmpty()) {
            pBlockEntity.open += 0.1f;
            if (pBlockEntity.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = pBlockEntity.flipT;
                do {
                    pBlockEntity.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == pBlockEntity.flipT);
            }
        } else {
            pBlockEntity.open -= 0.1f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = pBlockEntity.tRot - pBlockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += f2 * 0.4f;
        pBlockEntity.open = Mth.clamp((float)pBlockEntity.open, (float)0.0f, (float)1.0f);
        ++pBlockEntity.time;
        pBlockEntity.oFlip = pBlockEntity.flip;
        float f = (pBlockEntity.flipT - pBlockEntity.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)f3);
        pBlockEntity.flipA += (f - pBlockEntity.flipA) * 0.9f;
        pBlockEntity.flip += pBlockEntity.flipA;
    }

    private boolean processRecipe() {
        if (this.level == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 200) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        this.inventory.setStackInSlot(0, resultStack.copy());
        this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private ItemStack getResultItem() {
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        RandomSource rand = this.getLevel().getRandom();
        Registry<SupportCard> registry = UmapyoiAPI.getSupportCardRegistry(this.getLevel());
        @NotNull Collection keys = registry.keySet().stream().filter(this.getFilter(this.getLevel(), this.getStoredItem())).collect(Collectors.toCollection(Lists::newArrayList));
        ResourceLocation key = keys.stream().skip(keys.isEmpty() ? 0L : (long)rand.nextInt(keys.size())).findFirst().orElse(ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"blank_card"));
        ItemStack result = SupportCard.init(key, (SupportCard)registry.get(key));
        return result;
    }

    private boolean canWork() {
        return !this.getStoredItem().isEmpty() && this.getStoredItem().is(UmapyoiItemTags.CARD_TICKET) && !this.getStoredItem().is(UmapyoiItemTags.SSR_CARD_TICKET);
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    @Override
    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.inventory.setStackInSlot(0, itemStack.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().split(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.EMPTY;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        drops.add((Object)this.inventory.getStackInSlot(0));
        return drops;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.recipeTime = compound.getInt("RecipeTime");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("RecipeTime", this.recipeTime);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    private CompoundTag writeItems(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        return compound;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                SilverSupportAlbumPedestalBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                switch (index) {
                    case 0: {
                        return SilverSupportAlbumPedestalBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        SilverSupportAlbumPedestalBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @Override
    public Predicate<? super ResourceLocation> getFilter(Level level, ItemStack input) {
        return resloc -> {
            if (input.has(DataComponentsTypeRegistry.DATA_LOCATION)) {
                return resloc.equals((Object)((DataLocation)input.get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
            }
            if (input.is(UmapyoiItemTags.SR_CARD_TICKET)) {
                return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).get(resloc)).getGachaRanking() == GachaRanking.SR;
            }
            if (input.is(UmapyoiItemTags.COMMON_GACHA_ITEM)) {
                return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).get(resloc)).getGachaRanking() == GachaRanking.R;
            }
            boolean cfgFlag = GachaUtils.checkGachaConfig();
            int ssrHit = cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SSR.get() : 10;
            int gacha_roll = level.getRandom().nextInt(cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SUM.get() : 100);
            int srHit = ssrHit + (cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SR.get() : 20);
            return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).get(resloc)).getGachaRanking() == (gacha_roll < srHit ? GachaRanking.SR : GachaRanking.R);
        };
    }
}

