/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.container.ThreeGoddessContainer;
import net.tracen.umapyoi.inventory.ThreeGoddessItemHandler;
import net.tracen.umapyoi.item.FadedUmaSoulItem;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="umapyoi")
public class ThreeGoddessBlockEntity
extends SyncedBlockEntity
implements MenuProvider {
    public static final int MAX_PROCESS_TIME = 200;
    private final ItemStackHandler inventory = this.createHandler();
    private final IItemHandler inputHandler = new ThreeGoddessItemHandler((IItemHandler)this.inventory, Direction.UP);
    private final IItemHandler outputHandler = new ThreeGoddessItemHandler((IItemHandler)this.inventory, Direction.DOWN);
    protected final ContainerData tileData = this.createIntArray();
    private int recipeTime;
    private int animationTime;

    public int getProcessTime() {
        return this.recipeTime;
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public ThreeGoddessBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get(), pos, state);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get(), (be, context) -> {
            if (context == Direction.UP) {
                return be.inputHandler;
            }
            return be.outputHandler;
        });
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, ThreeGoddessBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, ThreeGoddessBlockEntity blockEntity) {
        ++blockEntity.animationTime;
        if (blockEntity.canWork()) {
            ThreeGoddessBlockEntity.addWorkingParticle(level, pos);
        }
        blockEntity.animationTime %= 360;
    }

    private static void addWorkingParticle(Level pLevel, BlockPos pPos) {
        RandomSource pRand = pLevel.getRandom();
        List<BlockPos> posOffsets = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.getX()) == 2 || Math.abs(pos.getZ()) == 2).map(BlockPos::immutable).toList();
        for (BlockPos spawnPos : posOffsets) {
            if (pRand.nextInt(32) != 0) continue;
            pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pPos.getX() + 0.5, (double)pPos.getY() + 2.5, (double)pPos.getZ() + 0.5, (double)((float)spawnPos.getX() + pRand.nextFloat() * 2.0f) - 0.5, (double)spawnPos.getY() + 2.0 - (double)pRand.nextFloat(), (double)((float)spawnPos.getZ() + pRand.nextFloat() * 2.0f) - 0.5);
        }
    }

    private boolean processRecipe() {
        if (this.level == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 200) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        if (resultStack.isEmpty()) {
            return true;
        }
        this.inventory.setStackInSlot(3, resultStack.copy());
        this.inventory.getStackInSlot(0).shrink(1);
        this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private ItemStack getResultItem() {
        ResourceLocation name;
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        ItemStack left = this.inventory.getStackInSlot(1);
        ItemStack right = this.inventory.getStackInSlot(2);
        Registry<UmaData> registry = UmapyoiAPI.getUmaDataRegistry(this.getLevel());
        name = registry.containsKey(name = ((DataLocation)this.inventory.getStackInSlot(0).getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name()) ? name : UmaData.DEFAULT_UMA_ID;
        UmaData data = registry.getOptional(name).orElse(UmaData.DEFAULT_UMA);
        ItemStack result = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).getDefaultInstance(), name, data).copy();
        if (!left.isEmpty() && !right.isEmpty()) {
            UmaFactorUtils.deserializeData((List)left.get(DataComponentsTypeRegistry.FACTOR_DATA)).forEach(fac -> fac.applyFactor(result));
            UmaFactorUtils.deserializeData((List)right.get(DataComponentsTypeRegistry.FACTOR_DATA)).forEach(fac -> fac.applyFactor(result));
        }
        return result;
    }

    private boolean canWork() {
        if (!this.hasInput()) {
            return false;
        }
        ItemStack outputStack = this.inventory.getStackInSlot(3);
        return outputStack.isEmpty();
    }

    private boolean hasInput() {
        return this.inventory.getStackInSlot(0).getItem() instanceof FadedUmaSoulItem && this.inventory.getStackInSlot(1).isEmpty() == this.inventory.getStackInSlot(2).isEmpty();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 4; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.recipeTime = compound.getInt("RecipeTime");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("RecipeTime", this.recipeTime);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    private CompoundTag writeItems(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        return compound;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                ThreeGoddessBlockEntity.this.inventoryChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                ItemStack motherSlot = this.getStackInSlot(2);
                ItemStack fatherSlot = this.getStackInSlot(1);
                ResourceLocation fatherName = ((DataLocation)fatherSlot.getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name();
                ResourceLocation motherName = ((DataLocation)motherSlot.getOrDefault(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name();
                if (slot == 0) {
                    if (stack.is((Item)ItemRegistry.BLANK_UMA_SOUL.get())) {
                        ResourceLocation name = ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
                        return (fatherSlot.isEmpty() || !name.equals((Object)fatherName)) && !name.equals((Object)motherName);
                    }
                    return false;
                }
                if (slot == 1) {
                    boolean result = stack.is((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
                    boolean factorFlag = false;
                    ResourceLocation name = ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
                    ItemStack soulStack = this.getStackInSlot(0);
                    boolean soulFlag = !soulStack.isEmpty() && ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name().equals((Object)((DataLocation)soulStack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
                    factorFlag = motherSlot.isEmpty() ? false : name.equals((Object)motherName);
                    return result && !soulFlag && !factorFlag;
                }
                if (slot == 2) {
                    boolean result = stack.is((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
                    boolean factorFlag = false;
                    ResourceLocation name = ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name();
                    ItemStack soulStack = this.getStackInSlot(0);
                    boolean soulFlag = !soulStack.isEmpty() && ((DataLocation)stack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name().equals((Object)((DataLocation)soulStack.get(DataComponentsTypeRegistry.DATA_LOCATION)).name());
                    factorFlag = fatherSlot.isEmpty() ? false : name.equals((Object)fatherName);
                    return result && !soulFlag && !factorFlag;
                }
                return super.isItemValid(slot, stack);
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                switch (index) {
                    case 0: {
                        return ThreeGoddessBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ThreeGoddessBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new ThreeGoddessContainer(id, player, this, this.tileData);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.umapyoi.three_goddess");
    }
}

