/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ActionBarOverlay
implements LayeredDraw.Layer {
    public static final ActionBarOverlay INSTANCE = new ActionBarOverlay();
    private final Minecraft minecraft = Minecraft.getInstance();
    private static final ResourceLocation HUD = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/actionbar.png");

    private ActionBarOverlay() {
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker tracker) {
        if (!((Boolean)UmapyoiConfig.OVERLAY_SWITCH.get()).booleanValue()) {
            return;
        }
        int x = guiGraphics.guiWidth();
        int y = guiGraphics.guiHeight();
        LocalPlayer player = this.minecraft.player;
        if (player.isSpectator()) {
            return;
        }
        if (!UmapyoiAPI.getUmaSoul((LivingEntity)player).isEmpty()) {
            this.renderSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), guiGraphics, x - 8, y - 64);
        }
    }

    private void renderSkill(ItemStack soul, GuiGraphics guiGraphics, int x, int y) {
        int maxAp;
        int ap = UmaSoulUtils.getActionPoint(soul);
        if (ap == (maxAp = UmaSoulUtils.getMaxActionPoint(soul))) {
            return;
        }
        guiGraphics.blit(HUD, x, y - 128, 11.0f, 0.0f, 5, 128, 16, 128);
        int apbar = ap != 0 ? ap * 128 / maxAp : 0;
        guiGraphics.blit(HUD, x, y - apbar, 6.0f, (float)(128 - apbar), 5, apbar, 16, 128);
        guiGraphics.blit(HUD, x - 7, y - 3 - apbar, 0.0f, 0.0f, 6, 7, 16, 128);
        String str = String.valueOf(ap);
        guiGraphics.drawString(this.minecraft.font, str, x - 8 - this.minecraft.font.width(str), y - 3 - apbar, 0xFFFFFF);
    }
}

