/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.model;

import cn.mcmod_mmf.mmlib.client.model.BedrockHumanoidModel;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ElytraItem;
import net.tracen.umapyoi.UmapyoiConfig;

public class UmaPlayerModel<T extends LivingEntity>
extends BedrockHumanoidModel<T> {
    public BedrockPart rightArmDown;
    public BedrockPart leftArmDown;
    public BedrockPart rightLegDown;
    public BedrockPart leftLegDown;
    public BedrockPart rightEar;
    public BedrockPart leftEar;
    public BedrockPart rightEarHideParts;
    public BedrockPart leftEarHideParts;
    public BedrockPart rightFoot;
    public BedrockPart leftFoot;
    public BedrockPart rightLegHideParts;
    public BedrockPart leftLegHideParts;
    public BedrockPart hat;
    public BedrockPart hideParts;
    public BedrockPart tail;
    public BedrockPart tailDown;
    public BedrockPart cape;
    public List<BedrockPart> longHairParts;

    public UmaPlayerModel() {
    }

    public UmaPlayerModel(BedrockModelPOJO pojo) {
        super(pojo);
    }

    public void loadModel(BedrockModelPOJO pojo) {
        super.loadModel(pojo);
        this.rightArmDown = this.getChild("right_arm_down");
        this.leftArmDown = this.getChild("left_arm_down");
        this.rightLegDown = this.getChild("right_leg_down");
        this.leftLegDown = this.getChild("left_leg_down");
        this.rightEar = this.getChild("right_ear");
        this.leftEar = this.getChild("left_ear");
        this.rightFoot = this.getChild("right_foot");
        this.leftFoot = this.getChild("left_foot");
        this.hat = this.getChild("hat") != null ? this.getChild("hat") : new BedrockPart();
        this.cape = this.getChild("cape") != null ? this.getChild("cape") : new BedrockPart();
        this.hideParts = this.getChild("hide_parts") != null ? this.getChild("hide_parts") : new BedrockPart();
        this.rightEarHideParts = this.getChild("right_earmuffs");
        this.leftEarHideParts = this.getChild("left_earmuffs");
        this.rightLegHideParts = this.getChild("right_leg_hide_parts") != null ? this.getChild("right_leg_hide_parts") : new BedrockPart();
        this.leftLegHideParts = this.getChild("left_leg_hide_parts") != null ? this.getChild("left_leg_hide_parts") : new BedrockPart();
        this.tail = this.getChild("tail");
        this.tailDown = this.getChild("tail_down");
        this.longHairParts = Lists.newArrayList();
        this.getModelMap().forEach((name, part) -> {
            if (name.startsWith("long_hair_") || name.equals("long_hair")) {
                this.longHairParts.add((BedrockPart)part);
            }
        });
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entityIn, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (entityIn instanceof ArmorStand) {
            ArmorStand entityarmorstand = (ArmorStand)entityIn;
            this.head.xRot = (float)Math.PI / 180 * entityarmorstand.getHeadPose().getX();
            this.head.yRot = (float)Math.PI / 180 * entityarmorstand.getHeadPose().getY();
            this.head.zRot = (float)Math.PI / 180 * entityarmorstand.getHeadPose().getZ();
            this.head.setPos(0.0f, 1.0f, 0.0f);
            this.body.xRot = (float)Math.PI / 180 * entityarmorstand.getBodyPose().getX();
            this.body.yRot = (float)Math.PI / 180 * entityarmorstand.getBodyPose().getY();
            this.body.zRot = (float)Math.PI / 180 * entityarmorstand.getBodyPose().getZ();
            this.leftArm.xRot = (float)Math.PI / 180 * entityarmorstand.getLeftArmPose().getX();
            this.leftArm.yRot = (float)Math.PI / 180 * entityarmorstand.getLeftArmPose().getY();
            this.leftArm.zRot = (float)Math.PI / 180 * entityarmorstand.getLeftArmPose().getZ();
            this.rightArm.xRot = (float)Math.PI / 180 * entityarmorstand.getRightArmPose().getX();
            this.rightArm.yRot = (float)Math.PI / 180 * entityarmorstand.getRightArmPose().getY();
            this.rightArm.zRot = (float)Math.PI / 180 * entityarmorstand.getRightArmPose().getZ();
            this.leftLeg.xRot = (float)Math.PI / 180 * entityarmorstand.getLeftLegPose().getX();
            this.leftLeg.yRot = (float)Math.PI / 180 * entityarmorstand.getLeftLegPose().getY();
            this.leftLeg.zRot = (float)Math.PI / 180 * entityarmorstand.getLeftLegPose().getZ();
            this.leftLeg.setPos(1.9f, 11.0f, 0.0f);
            this.rightLeg.xRot = (float)Math.PI / 180 * entityarmorstand.getRightLegPose().getX();
            this.rightLeg.yRot = (float)Math.PI / 180 * entityarmorstand.getRightLegPose().getY();
            this.rightLeg.zRot = (float)Math.PI / 180 * entityarmorstand.getRightLegPose().getZ();
            this.rightLeg.setPos(-1.9f, 11.0f, 0.0f);
        } else {
            this.tail.copyFrom(this.body);
            if (this.crouching) {
                this.tail.xRot = 1.0f + pLimbSwingAmount * 0.5f;
                this.tail.z = 3.125f;
                this.tail.y = 11.0f;
                this.cape.xRot = 1.0f + pLimbSwingAmount * 0.5f;
            } else {
                this.tail.xRot = pLimbSwingAmount * 1.0f;
                this.tail.z = 1.75f;
                this.tail.y = 8.0f;
                this.cape.xRot = pLimbSwingAmount * 1.0f;
            }
            if (this.head.xRot < 0.0f) {
                this.longHairParts.forEach(part -> {
                    part.xRot = -this.head.xRot;
                });
            } else {
                this.longHairParts.forEach(part -> {
                    part.xRot = 0.0f;
                });
            }
            this.animationEarTail(entityIn, pAgeInTicks);
        }
        this.hat.copyFrom(this.head);
    }

    private void animationEarTail(T entityIn, float pAgeInTicks) {
        int ears_reminder = (int)((pAgeInTicks + (float)(Math.abs(entityIn.getUUID().getLeastSignificantBits()) % 10L)) % (float)((Integer)UmapyoiConfig.EAR_ANIMATION_INTERVAL.get()).intValue());
        int tail_reminder = (int)((pAgeInTicks + (float)(Math.abs(entityIn.getUUID().getLeastSignificantBits()) % 10L)) % (float)((Integer)UmapyoiConfig.TAIL_ANIMATION_INTERVAL.get()).intValue());
        float earRot = Mth.cos((float)ears_reminder) * 0.125f;
        if (0 < ears_reminder && ears_reminder < 8) {
            if (this.leftEarHideParts != null) {
                this.leftEarHideParts.zRot = earRot;
            }
            if (this.rightEarHideParts != null) {
                this.rightEarHideParts.zRot = -earRot;
            }
            this.leftEar.zRot = earRot;
            this.rightEar.zRot = -earRot;
        } else {
            if (this.leftEarHideParts != null) {
                this.leftEarHideParts.zRot = 0.0f;
            }
            if (this.rightEarHideParts != null) {
                this.rightEarHideParts.zRot = 0.0f;
            }
            this.leftEar.zRot = 0.0f;
            this.rightEar.zRot = 0.0f;
        }
        if (0 < tail_reminder && tail_reminder < 8) {
            this.tail.zRot = -Mth.cos((float)(pAgeInTicks * 0.7f)) * 0.5f;
            this.tail.yRot = Mth.cos((float)(pAgeInTicks * 0.7f)) * 0.5f;
        } else {
            this.tail.zRot = 0.0f;
            this.tail.yRot = 0.0f;
        }
    }

    public void setModelProperties(LivingEntity player) {
        boolean shouldSit;
        this.riding = shouldSit = player.isPassenger() && player.getVehicle() != null && player.getVehicle().shouldRiderSit();
        if (player.isSpectator()) {
            this.setAllVisible(false);
            this.head.visible = true;
        } else {
            this.setAllVisible(true);
            this.crouching = player.isCrouching();
            if (((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && !((Boolean)UmapyoiConfig.HIDE_PARTS_RENDER.get()).booleanValue()) {
                this.hat.visible = player.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
                if (!player.getItemBySlot(EquipmentSlot.CHEST).isEmpty() && !(player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ElytraItem)) {
                    this.hideParts.visible = false;
                    this.cape.visible = false;
                } else {
                    this.hideParts.visible = true;
                    this.cape.visible = true;
                }
                if (!player.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                    this.rightLegHideParts.visible = false;
                    this.leftLegHideParts.visible = false;
                } else {
                    this.rightLegHideParts.visible = true;
                    this.leftLegHideParts.visible = true;
                }
                if (!player.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
                    this.rightFoot.visible = false;
                    this.leftFoot.visible = false;
                } else {
                    this.rightFoot.visible = true;
                    this.leftFoot.visible = true;
                }
            }
            if (this.hat.visible) {
                if (this.leftEarHideParts != null) {
                    this.leftEar.visible = false;
                }
                if (this.rightEarHideParts != null) {
                    this.rightEar.visible = false;
                }
            } else {
                if (this.leftEarHideParts != null) {
                    this.leftEar.visible = true;
                }
                if (this.rightEarHideParts != null) {
                    this.rightEar.visible = true;
                }
            }
        }
    }

    public void copyAnim(BedrockPart part, ModelPart old_part) {
        part.xRot = old_part.xRot;
        part.yRot = old_part.yRot;
        part.zRot = old_part.zRot;
        part.x = old_part.x;
        if (part == this.leftArm) {
            part.x -= 1.0f;
        }
        if (part == this.rightArm) {
            part.x += 1.0f;
        }
        if (part == this.leftLeg) {
            part.x -= 0.125f;
        }
        if (part == this.rightLeg) {
            part.x += 0.125f;
        }
        part.y = old_part.y;
        part.z = old_part.z;
        if (part == this.leftLeg) {
            part.z -= 0.125f;
        }
        if (part == this.rightLeg) {
            part.z -= 0.125f;
        }
    }

    public void showHat() {
        this.hat.visible = true;
    }

    public void hideHat() {
        this.hat.visible = true;
    }
}

