/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.tracen.umapyoi.client.model.UmaPlayerModel;
import net.tracen.umapyoi.data.tag.UmapyoiUmaDataTags;
import net.tracen.umapyoi.events.client.RenderingUmaSuitEvent;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public abstract class AbstractSuitRenderer
implements ICurioRenderer {
    private final UmaPlayerModel<LivingEntity> baseModel = new UmaPlayerModel();

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        if (entity.isInvisible()) {
            return;
        }
        if (!slotContext.identifier().equalsIgnoreCase("uma_suit")) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(itemHandler -> itemHandler.getStacksHandler("uma_soul").ifPresent(stacksHandler -> {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            boolean flat_flag = false;
            boolean tanned = false;
            if (stackHandler.getSlots() > 0) {
                ItemStack stackInSlot = stackHandler.getStackInSlot(0);
                if (stackInSlot.isEmpty()) {
                    return;
                }
                if (!(stackInSlot.getItem() instanceof UmaSoulItem)) {
                    return;
                }
                if (!((Boolean)stacksHandler.getRenders().get(0)).booleanValue()) {
                    return;
                }
                flat_flag = ((Holder.Reference)ClientUtils.getClientUmaDataRegistry().getHolder(ResourceKey.create(UmaData.REGISTRY_KEY, (ResourceLocation)UmaSoulUtils.getName(stackInSlot))).get()).is(UmapyoiUmaDataTags.FLAT_CHEST);
                tanned = ((Holder.Reference)ClientUtils.getClientUmaDataRegistry().getHolder(ResourceKey.create(UmaData.REGISTRY_KEY, (ResourceLocation)UmaSoulUtils.getName(stackInSlot))).get()).is(UmapyoiUmaDataTags.TANNED_SKIN);
            }
            VertexConsumer vertexconsumer = renderTypeBuffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)(flat_flag ? this.getFlatTexture(tanned) : this.getTexture(tanned))));
            BedrockModelPOJO pojo = ClientUtil.getModelPOJO((ResourceLocation)(flat_flag ? this.getFlatModel() : this.getModel()));
            if (this.baseModel.needRefresh(pojo)) {
                this.baseModel.loadModel(pojo);
            }
            if (((RenderingUmaSuitEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderingUmaSuitEvent.Pre(entity, this.baseModel, partialTicks, matrixStack, renderTypeBuffer, light))).isCanceled()) {
                return;
            }
            this.baseModel.setModelProperties(entity);
            this.baseModel.head.visible = false;
            this.baseModel.tail.visible = false;
            this.baseModel.hat.visible = false;
            this.baseModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
            if (renderLayerParent.getModel() instanceof HumanoidModel) {
                HumanoidModel model = (HumanoidModel)renderLayerParent.getModel();
                this.baseModel.copyAnim(this.baseModel.head, model.head);
                this.baseModel.copyAnim(this.baseModel.body, model.body);
                this.baseModel.copyAnim(this.baseModel.leftArm, model.leftArm);
                this.baseModel.copyAnim(this.baseModel.leftLeg, model.leftLeg);
                this.baseModel.copyAnim(this.baseModel.rightArm, model.rightArm);
                this.baseModel.copyAnim(this.baseModel.rightLeg, model.rightLeg);
            }
            this.baseModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.baseModel.renderToBuffer(matrixStack, vertexconsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            NeoForge.EVENT_BUS.post((Event)new RenderingUmaSuitEvent.Post(entity, this.baseModel, partialTicks, matrixStack, renderTypeBuffer, light));
        }));
    }

    protected abstract ResourceLocation getModel();

    protected abstract ResourceLocation getTexture(boolean var1);

    protected abstract ResourceLocation getFlatModel();

    protected abstract ResourceLocation getFlatTexture(boolean var1);
}

