/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.SilverUmaPedestalBlock;
import net.tracen.umapyoi.block.entity.SilverUmaPedestalBlockEntity;

public class SilverUmaPedestalBlockRender
implements BlockEntityRenderer<SilverUmaPedestalBlockEntity> {
    public SilverUmaPedestalBlockRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(SilverUmaPedestalBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState blockstate;
        Level world = tileEntity.getLevel();
        boolean flag = world != null;
        BlockState blockState = blockstate = flag ? tileEntity.getBlockState() : ((SilverUmaPedestalBlock)((Object)BlockRegistry.SILVER_UMA_PEDESTAL.get())).defaultBlockState();
        if (blockstate.getBlock() instanceof SilverUmaPedestalBlock) {
            this.renderAnimation(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderAnimation(SilverUmaPedestalBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack item = tileEntity.getStoredItem();
        if (item.isEmpty()) {
            return;
        }
        BlockPos pPos = tileEntity.getBlockPos();
        this.renderItem(tileEntity, partialTicks, poseStack);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, tileEntity.getLevel(), (int)pPos.asLong());
    }

    private void renderItem(SilverUmaPedestalBlockEntity tileEntity, float partialTicks, PoseStack matrixStackIn) {
        float f = ((float)tileEntity.getAnimationTime() + partialTicks) / 20.0f;
        float f1 = Mth.sin((float)f) * 0.1f + 0.1f;
        matrixStackIn.translate(0.5, (double)f1 + 1.5, 0.5);
        matrixStackIn.mulPose(Axis.YP.rotation(f));
        matrixStackIn.scale(0.6f, 0.6f, 0.6f);
    }
}

