/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.SupportAlbumPedestalBlock;
import net.tracen.umapyoi.block.entity.SupportAlbumPedestalBlockEntity;

public class SupportAlbumPedestalBlockRender
implements BlockEntityRenderer<SupportAlbumPedestalBlockEntity> {
    private final BookModel bookModel;

    public SupportAlbumPedestalBlockRender(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(SupportAlbumPedestalBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState blockstate;
        Level world = tileEntity.getLevel();
        boolean flag = world != null;
        BlockState blockState = blockstate = flag ? tileEntity.getBlockState() : ((SupportAlbumPedestalBlock)((Object)BlockRegistry.SUPPORT_ALBUM_PEDESTAL.get())).defaultBlockState();
        if (blockstate.getBlock() instanceof SupportAlbumPedestalBlock) {
            this.renderBook(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
            this.renderAnimation(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderAnimation(SupportAlbumPedestalBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack item = tileEntity.getStoredItem();
        if (item.isEmpty()) {
            return;
        }
        BlockPos pPos = tileEntity.getBlockPos();
        this.renderItem(tileEntity, partialTicks, poseStack);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, tileEntity.getLevel(), (int)pPos.asLong());
    }

    private void renderItem(SupportAlbumPedestalBlockEntity tileEntity, float partialTicks, PoseStack matrixStackIn) {
        float f = ((float)tileEntity.getAnimationTime() + partialTicks) / 20.0f;
        float f1 = Mth.sin((float)f) * 0.1f + 0.1f;
        matrixStackIn.translate(0.5, (double)f1 + 1.5, 0.5);
        matrixStackIn.mulPose(Axis.YP.rotation(f));
        matrixStackIn.scale(0.6f, 0.6f, 0.6f);
    }

    public void renderBook(SupportAlbumPedestalBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        float f1;
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 1.0, 0.5);
        float f = (float)pBlockEntity.time + pPartialTick;
        pPoseStack.translate(0.0, (double)(0.1f + Mth.sin((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = pBlockEntity.rot - pBlockEntity.oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = pBlockEntity.oRot + f1 * pPartialTick;
        pPoseStack.mulPose(Axis.YP.rotation(-f2));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(80.0f));
        float f3 = Mth.lerp((float)pPartialTick, (float)pBlockEntity.oFlip, (float)pBlockEntity.flip);
        float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.lerp((float)pPartialTick, (float)pBlockEntity.oOpen, (float)pBlockEntity.open);
        this.bookModel.setupAnim(f, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/model/support_card_album.png")));
        this.bookModel.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
    }
}

