/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.container.SkillLearningMenu;
import net.tracen.umapyoi.item.SkillBookItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class SkillLearningScreen
extends ItemCombinerScreen<SkillLearningMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/skill_learning.png");

    public SkillLearningScreen(SkillLearningMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((ItemCombinerMenu)pMenu, pPlayerInventory, pTitle, BACKGROUND_TEXTURE);
    }

    protected void renderLabels(GuiGraphics graphic, int mouseX, int mouseY) {
        graphic.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getVisualOrderText()) / 2, this.titleLabelY - 3, 0xFFFFFF);
        graphic.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040);
        UmaSkill skill = this.getBookSkill();
        if (skill != null) {
            boolean slot_needed;
            graphic.drawString(this.font, skill.getDescription(), 51, 20, 7946262);
            ItemStack soul = ((SkillLearningMenu)this.getMenu()).getSlot(0).hasItem() ? ((SkillLearningMenu)this.getMenu()).getSlot(0).getItem() : ItemStack.EMPTY;
            boolean has_retired = !soul.has(DataComponentsTypeRegistry.UMADATA_TRAINING);
            boolean has_learned = UmaSoulUtils.getSkills(soul).contains(UmaSkillRegistry.REGISTRY.getKey((Object)skill));
            boolean has_learned_upper = skill.getUpperSkill() != null && UmaSoulUtils.getSkills(soul).contains(skill.getUpperSkill());
            boolean bl = slot_needed = !soul.isEmpty() && !UmaSoulUtils.hasEmptySkillSlot(soul);
            if (has_learned || has_learned_upper) {
                graphic.drawString(this.font, (Component)Component.translatable((String)"umapyoi.skill.has_learned_skill"), 51, 31, 7946262);
            } else if (has_retired) {
                graphic.drawString(this.font, (Component)Component.translatable((String)"umapyoi.skill.has_retired"), 51, 31, 7946262);
            } else if (slot_needed) {
                graphic.drawString(this.font, (Component)Component.translatable((String)"umapyoi.skill.slot_needed"), 51, 31, 7946262);
            } else if (skill.getRequiredWisdom() > 0) {
                graphic.drawString(this.font, (Component)Component.translatable((String)"umapyoi.skill.require_wisdom", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(skill.getRequiredWisdom())}), 51, 31, 7946262);
            } else {
                graphic.drawString(this.font, (Component)Component.translatable((String)"umapyoi.skill.no_require"), 51, 31, 7946262);
            }
        }
    }

    protected void renderBg(GuiGraphics graphic, float pPartialTick, int pX, int pY) {
        super.renderBg(graphic, pPartialTick, pX, pY);
        UmaSkill skill = this.getBookSkill();
        if (skill != null) {
            int i = (this.width - this.imageWidth) / 2;
            int j = (this.height - this.imageHeight) / 2;
            switch (skill.getType()) {
                case BUFF: {
                    graphic.blit(BACKGROUND_TEXTURE, i + 31, j + 21, 176, 21, 16, 16);
                    break;
                }
                case HINDER: {
                    graphic.blit(BACKGROUND_TEXTURE, i + 31, j + 21, 176, 37, 16, 16);
                    break;
                }
                case HEAL: {
                    graphic.blit(BACKGROUND_TEXTURE, i + 31, j + 21, 176, 53, 16, 16);
                    break;
                }
                case PASSIVE: {
                    graphic.blit(BACKGROUND_TEXTURE, i + 31, j + 21, 176, 69, 16, 16);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)skill.getType()));
                }
            }
        }
    }

    private UmaSkill getBookSkill() {
        ItemStack book = ((SkillLearningMenu)this.getMenu()).getSlot(1).hasItem() ? ((SkillLearningMenu)this.getMenu()).getSlot(1).getItem() : ItemStack.EMPTY;
        Item item = book.getItem();
        if (item instanceof SkillBookItem) {
            SkillBookItem skillBook = (SkillBookItem)item;
            UmaSkill skill = skillBook.getSkill(book);
            return skill;
        }
        return null;
    }

    protected void renderErrorIcon(GuiGraphics graphic, int x, int y) {
        if ((((SkillLearningMenu)this.menu).getSlot(0).hasItem() || ((SkillLearningMenu)this.menu).getSlot(1).hasItem()) && !((SkillLearningMenu)this.menu).getSlot(((SkillLearningMenu)this.menu).getResultSlot()).hasItem()) {
            graphic.blit(BACKGROUND_TEXTURE, x + 99, y + 45, this.imageWidth, 0, 28, 21);
        }
    }
}

