/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tracen.umapyoi.container.TrainingFacilityContainer;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TrainingFacilityScreen
extends AbstractContainerScreen<TrainingFacilityContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/training_snap.png");

    public TrainingFacilityScreen(TrainingFacilityContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.leftPos = 0;
        this.topPos = 0;
        this.imageWidth = 176;
        this.imageHeight = 202;
    }

    public void render(GuiGraphics graphic, int mouseX, int mouseY, float partialTicks) {
        super.render(graphic, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphic, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphic, int mouseX, int mouseY) {
        graphic.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getVisualOrderText()) / 2, this.titleLabelY - 3, 0xFFFFFF);
        graphic.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphic, float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphic.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderSupportBG(graphic);
        this.renderTrainingAnim(graphic);
        this.renderSupportTypes(graphic);
        this.renderUmaSoulPhysique(graphic);
    }

    private void renderUmaSoulPhysique(GuiGraphics graphic) {
        ItemStack soul = ((TrainingFacilityContainer)this.getMenu()).inventory.getStackInSlot(0);
        if (soul.getItem() instanceof UmaSoulItem) {
            if (!soul.has(DataComponentsTypeRegistry.UMADATA_TRAINING)) {
                return;
            }
            graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 102, this.topPos + 103, 0, 246, 65, 5);
            int training_times = 5 - UmaSoulUtils.getPhysique(soul);
            graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 102, this.topPos + 103, 0, 251, training_times * 13, 5);
        }
    }

    private void renderSupportTypes(GuiGraphics graphic) {
        int i;
        int[] types = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        block9: for (i = 1; i < 7; ++i) {
            ItemStack stack = ((TrainingFacilityContainer)this.getMenu()).inventory.getStackInSlot(i);
            Item item = stack.getItem();
            if (!(item instanceof SupportContainer)) continue;
            SupportContainer support = (SupportContainer)item;
            switch (support.getSupportType((Level)this.minecraft.level, stack)) {
                case SPEED: {
                    types[0] = types[0] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 0, this.topPos + 42, 3, 219, 12, 12);
                    continue block9;
                }
                case STAMINA: {
                    types[1] = types[1] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 23, this.topPos + 42, 26, 219, 12, 12);
                    continue block9;
                }
                case STRENGTH: {
                    types[2] = types[2] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 46, this.topPos + 42, 49, 219, 12, 12);
                    continue block9;
                }
                case GUTS: {
                    types[3] = types[3] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 69, this.topPos + 42, 72, 219, 12, 12);
                    continue block9;
                }
                case WISDOM: {
                    types[4] = types[4] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 92, this.topPos + 42, 95, 219, 12, 12);
                    continue block9;
                }
                case FRIENDSHIP: {
                    types[5] = types[5] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 115, this.topPos + 42, 118, 219, 12, 12);
                    continue block9;
                }
                case GROUP: {
                    types[6] = types[6] + 1;
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 9 + 138, this.topPos + 42, 141, 219, 12, 12);
                    continue block9;
                }
            }
        }
        for (i = 0; i < 7; ++i) {
            if (types[i] <= 0) continue;
            graphic.drawString(this.font, (Component)Component.literal((String)String.valueOf(types[i])), this.leftPos + 23 + i * 23, this.topPos + 44, 8835080);
        }
    }

    private void renderSupportBG(GuiGraphics graphic) {
        SupportContainer support;
        Item item;
        ItemStack stack;
        int i;
        block10: for (i = 1; i < 4; ++i) {
            stack = ((TrainingFacilityContainer)this.getMenu()).inventory.getStackInSlot(i);
            item = stack.getItem();
            if (!(item instanceof SupportContainer)) continue;
            support = (SupportContainer)item;
            switch (support.getSupportLevel((Level)this.minecraft.level, stack)) {
                case EASTER_EGG: 
                case R: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 7 + (i - 1) * 27, this.topPos + 14, 171, 205, 26, 26);
                    continue block10;
                }
                case SR: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 7 + (i - 1) * 27, this.topPos + 14, 198, 205, 26, 26);
                    continue block10;
                }
                case SSR: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 7 + (i - 1) * 27, this.topPos + 14, 225, 205, 26, 26);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)support.getSupportLevel((Level)this.minecraft.level, stack)));
                }
            }
        }
        block11: for (i = 4; i < 7; ++i) {
            stack = ((TrainingFacilityContainer)this.getMenu()).inventory.getStackInSlot(i);
            item = stack.getItem();
            if (!(item instanceof SupportContainer)) continue;
            support = (SupportContainer)item;
            switch (support.getSupportLevel((Level)this.minecraft.level, stack)) {
                case EASTER_EGG: 
                case R: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 89 + (i - 4) * 27, this.topPos + 14, 171, 205, 26, 26);
                    continue block11;
                }
                case SR: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 89 + (i - 4) * 27, this.topPos + 14, 198, 205, 26, 26);
                    continue block11;
                }
                case SSR: {
                    graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 89 + (i - 4) * 27, this.topPos + 14, 225, 205, 26, 26);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)support.getSupportLevel((Level)this.minecraft.level, stack)));
                }
            }
        }
    }

    private void renderTrainingAnim(GuiGraphics graphic) {
        int l = ((TrainingFacilityContainer)this.menu).getProgressionScaled();
        int n = ((TrainingFacilityContainer)this.menu).getAnimation();
        graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 10 + l, this.topPos + 68, 207, 88 + n * 24, 24, 24);
        graphic.blit(BACKGROUND_TEXTURE, this.leftPos + 8, this.topPos + 64, 181, 84, 25, 27);
    }
}

