/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tracen.umapyoi.container.UmaSelectMenu;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.item.data.GachaRankingData;
import net.tracen.umapyoi.network.EmptyResultPacket;
import net.tracen.umapyoi.network.SetupResultPacket;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaSelectScreen
extends AbstractContainerScreen<UmaSelectMenu>
implements ContainerListener {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"textures/gui/select_test.png");
    private EditBox searchBox;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 49;
    private static final int RECIPES_Y = 30;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private int selectIndex;
    private boolean displayRecipes;
    private String name;

    public UmaSelectScreen(UmaSelectMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 186;
        this.selectIndex = -1;
        this.name = "";
        pMenu.registerUpdateListener(this::containerChanged);
    }

    public void render(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderFg(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pPoseStack, pMouseX, pMouseY);
    }

    public void renderFg(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.searchBox.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderLabels(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        pPoseStack.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title.getVisualOrderText()) / 2, this.titleLabelY - 3, 0xFFFFFF);
        pPoseStack.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 20, 0x404040, false);
    }

    protected void subInit() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.searchBox = new EditBox(this.font, i + 42, j + 17, 90, 12, (Component)Component.translatable((String)"container.uma_select"));
        this.searchBox.setCanLoseFocus(false);
        this.searchBox.setTextColor(-1);
        this.searchBox.setTextColorUneditable(-1);
        this.searchBox.setBordered(false);
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(this::onNameChanged);
        this.searchBox.setValue("");
        this.addWidget((GuiEventListener)this.searchBox);
        this.searchBox.setEditable(this.displayRecipes);
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.searchBox.setValue(s);
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.searchBox);
    }

    protected void init() {
        super.init();
        this.subInit();
        ((UmaSelectMenu)this.menu).addSlotListener(this);
    }

    public void removed() {
        super.removed();
        ((UmaSelectMenu)this.menu).removeSlotListener(this);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return !this.searchBox.keyPressed(pKeyCode, pScanCode, pModifiers) && !this.searchBox.canConsumeInput() ? super.keyPressed(pKeyCode, pScanCode, pModifiers) : true;
    }

    private void onNameChanged(String name) {
        boolean hasItems;
        boolean bl = hasItems = ((UmaSelectMenu)this.menu).getSlot(0).hasItem() && ((UmaSelectMenu)this.menu).getSlot(1).hasItem();
        if (!hasItems) {
            return;
        }
        if (name.length() <= 50 && !this.name.equalsIgnoreCase(name)) {
            this.name = name;
            this.selectIndex = -1;
            PacketDistributor.sendToServer((CustomPacketPayload)EmptyResultPacket.packet(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pX, int pY) {
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BACKGROUND_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.blit(BACKGROUND_TEXTURE, i + 116, j + 31 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.leftPos + 49;
        int i1 = this.topPos + 30;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, pX, pY, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void renderTooltip(GuiGraphics pPoseStack, int pX, int pY) {
        super.renderTooltip(pPoseStack, pX, pY);
        if (this.displayRecipes) {
            int i = this.leftPos + 49;
            int j = this.topPos + 30;
            int k = this.startIndex + 12;
            List<ResourceLocation> list = this.getResults();
            for (int l = this.startIndex; l < k && l < this.getResults().size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 16 || pY < k1 || pY >= k1 + 18) continue;
                pPoseStack.renderTooltip(this.font, this.getResultItem(list.get(l)), pX, pY);
            }
        }
    }

    private void renderButtons(GuiGraphics pPoseStack, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex) {
        if (this.displayRecipes) {
            for (int i = this.startIndex; i < pLastVisibleElementIndex && i < this.getResults().size(); ++i) {
                int j = i - this.startIndex;
                int k = pX + j % 4 * 16;
                int l = j / 4;
                int i1 = pY + l * 18 + 2;
                int j1 = 15;
                if (i == this.selectIndex) {
                    j1 += 18;
                } else if (pMouseX >= k && pMouseY >= i1 && pMouseX < k + 16 && pMouseY < i1 + 18) {
                    j1 += 36;
                }
                pPoseStack.blit(BACKGROUND_TEXTURE, k, i1 - 1, 176, j1, 16, 18);
            }
        }
    }

    private void renderRecipes(GuiGraphics pPoseStack, int pLeft, int pTop, int pRecipeIndexOffsetMax) {
        if (this.displayRecipes) {
            List<ResourceLocation> list = this.getResults();
            for (int i = this.startIndex; i < pRecipeIndexOffsetMax && i < this.getResults().size(); ++i) {
                int j = i - this.startIndex;
                int k = pLeft + j % 4 * 16;
                int l = j / 4;
                int i1 = pTop + l * 18 + 2;
                pPoseStack.renderItem(this.getResultItem(list.get(i)), k, i1);
            }
        }
    }

    public List<ResourceLocation> getResults() {
        List<ResourceLocation> list = ((UmaSelectMenu)this.menu).getRecipes();
        ArrayList result = list.stream().filter(this.getFilter(((UmaSelectMenu)this.menu).getSlot(0).getItem())).sorted(UmaSelectMenu.SelectComparator.INSTANCE).collect(Collectors.toCollection(Lists::newArrayList));
        return result;
    }

    public Predicate<? super ResourceLocation> getFilter(ItemStack input) {
        return resloc -> {
            boolean rankingCheck;
            if (input.is(UmapyoiItemTags.CARD_TICKET)) {
                boolean rankingCheck2;
                SupportCard card = (SupportCard)ClientUtils.getClientSupportCardRegistry().get(resloc);
                boolean ssrRanking = input.is(UmapyoiItemTags.SSR_CARD_TICKET);
                boolean srRanking = input.is(UmapyoiItemTags.SR_CARD_TICKET);
                boolean bl = ssrRanking ? card.getGachaRanking() == GachaRanking.SSR : (srRanking ? card.getGachaRanking() == GachaRanking.SR : (rankingCheck2 = card.getGachaRanking() == GachaRanking.R));
                if (this.getName().isBlank()) {
                    return rankingCheck2;
                }
                String s = this.getName().toLowerCase(Locale.ROOT);
                if (s.startsWith("@")) {
                    s = s.substring(1);
                    return card.getSupporters().contains(ResourceLocation.tryParse((String)s)) && rankingCheck2;
                }
                MutableComponent localized = Component.translatable((String)(Util.makeDescriptionId((String)"support_card", (ResourceLocation)resloc) + ".name"));
                boolean nameCheck = resloc.toString().contains(s) || ChatFormatting.stripFormatting((String)localized.getString()).contains(s);
                return nameCheck && rankingCheck2;
            }
            UmaData uma = (UmaData)ClientUtils.getClientUmaDataRegistry().get(resloc);
            boolean ssrRanking = input.is(UmapyoiItemTags.SSR_UMA_TICKET);
            boolean srRanking = input.is(UmapyoiItemTags.SR_UMA_TICKET);
            boolean bl = ssrRanking ? uma.ranking() == GachaRanking.SSR : (srRanking ? uma.ranking() == GachaRanking.SR : (rankingCheck = uma.ranking() == GachaRanking.R));
            if (this.getName().isBlank()) {
                return rankingCheck;
            }
            String s = this.getName().toLowerCase(Locale.ROOT);
            if (s.startsWith("@")) {
                s = s.substring(1);
                return uma.identifier().equals((Object)ResourceLocation.tryParse((String)s)) && rankingCheck;
            }
            MutableComponent localized = Component.translatable((String)Util.makeDescriptionId((String)"umadata", (ResourceLocation)resloc));
            boolean nameCheck = resloc.toString().contains(s) || ChatFormatting.stripFormatting((String)localized.getString()).contains(s);
            return nameCheck && rankingCheck;
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private ItemStack getResultItem(ResourceLocation name) {
        if (((UmaSelectMenu)this.getMenu()).getSlot(0).getItem().is(UmapyoiItemTags.CARD_TICKET)) {
            Registry<SupportCard> registry = ClientUtils.getClientSupportCardRegistry();
            ItemStack result = ((Item)ItemRegistry.SUPPORT_CARD.get()).getDefaultInstance();
            result.set(DataComponents.MAX_DAMAGE, (Object)((SupportCard)registry.get(name)).getMaxDamage());
            result.set(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(name));
            result.set(DataComponentsTypeRegistry.GACHA_RANKING, (Object)new GachaRankingData(((SupportCard)registry.get(name)).getGachaRanking()));
            return result;
        }
        Registry<UmaData> registry = ClientUtils.getClientUmaDataRegistry();
        ItemStack initUmaSoul = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).getDefaultInstance(), name, (UmaData)registry.get(name));
        UmaSoulUtils.setPhysique(initUmaSoul, 5);
        return initUmaSoul;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 49;
            int j = this.topPos + 30;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                if (l >= this.getResults().size()) {
                    return super.mouseClicked(pMouseX, pMouseY, pButton);
                }
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 16);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.selectIndex = l;
                PacketDistributor.sendToServer((CustomPacketPayload)new SetupResultPacket(this.getResults().get(this.getSelectIndex()).toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 30;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.getResults().size() > 12;
    }

    protected int getOffscreenRows() {
        return (this.getResults().size() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        boolean bl = this.displayRecipes = ((UmaSelectMenu)this.menu).hasInputItem() && this.getResults().size() > 0;
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.selectIndex = -1;
        }
    }

    public void slotChanged(AbstractContainerMenu pContainerToSend, int pDataSlotIndex, ItemStack pStack) {
        boolean hasItems;
        boolean bl = hasItems = pContainerToSend.getSlot(0).hasItem() && pContainerToSend.getSlot(1).hasItem();
        if (!hasItems) {
            this.selectIndex = -1;
        }
        this.searchBox.setValue(!hasItems ? "" : this.searchBox.getValue());
        this.searchBox.setEditable(hasItems);
        this.setFocused((GuiEventListener)this.searchBox);
    }

    public void dataChanged(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }
}

