/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.UmaFactorRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.SkillFactor;
import net.tracen.umapyoi.registry.factors.StatusFactor;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

public class RetireRegisterMenu
extends AbstractContainerMenu {
    private final DataSlot factorSeed = DataSlot.standalone();
    private final Random rand = new Random();
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(1){

        public int getContainerSize() {
            return 1;
        }

        public void setChanged() {
            super.setChanged();
            RetireRegisterMenu.this.slotsChanged((Container)this);
        }
    };
    protected final ContainerLevelAccess access;
    protected final Player player;

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    protected boolean hasResult() {
        ItemStack inputSoul = this.inputSlots.getItem(0);
        if (inputSoul.getItem() instanceof UmaSoulItem) {
            return inputSoul.has(DataComponentsTypeRegistry.UMADATA_TRAINING);
        }
        return false;
    }

    protected void onTake(Player player, ItemStack resultStack) {
        resultStack.onCraftedBy(player.level(), player, resultStack.getCount());
        this.resultSlots.awardUsedRecipes(player, this.getRelevantItems());
        ItemStack inputSoul = this.inputSlots.getItem(0).copy();
        if (inputSoul.getItem() instanceof UmaSoulItem) {
            inputSoul.remove(DataComponentsTypeRegistry.UMADATA_TRAINING);
            this.inputSlots.setItem(0, inputSoul);
            this.access.execute((level, pos) -> player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.0f));
        }
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0));
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.is((Block)BlockRegistry.REGISTER_LECTERN.get());
    }

    public RetireRegisterMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL);
    }

    public RetireRegisterMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        this((MenuType)ContainerRegistry.RETIRE_REGISTER.get(), pContainerId, pPlayerInventory, pAccess);
    }

    public RetireRegisterMenu(@Nullable MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(pType, pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.player;
        this.addSlot(new Slot(this.inputSlots, 0, 44, 59));
        this.addSlot(new Slot((Container)this.resultSlots, 1, 116, 59){

            public boolean mayPlace(ItemStack p_39818_) {
                return false;
            }

            public boolean mayPickup(Player p_39813_) {
                return RetireRegisterMenu.this.mayPickup(p_39813_, this.hasItem());
            }

            public void onTake(Player p_150604_, ItemStack p_150605_) {
                RetireRegisterMenu.this.onTake(p_150604_, p_150605_);
                p_150604_.onEnchantmentPerformed(p_150605_, 0);
                RetireRegisterMenu.this.factorSeed.set(p_150604_.getEnchantmentSeed());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 152));
        }
        this.addDataSlot(this.factorSeed).set(this.player.getEnchantmentSeed());
    }

    public void createResult() {
        if (!this.hasResult()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            this.resultSlots.setItem(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack result = ((Item)ItemRegistry.UMA_FACTOR_ITEM.get()).getDefaultInstance();
        ItemStack inputSoul = this.inputSlots.getItem(0).copy();
        if (!(inputSoul.getItem() instanceof UmaSoulItem)) {
            return ItemStack.EMPTY;
        }
        int ranking = ResultRankingUtils.getRanking(inputSoul);
        this.rand.setSeed(this.getFactorSeed().get());
        List<UmaFactorStack> stackList = this.createResultFactors(inputSoul, ranking);
        result.set(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaSoulUtils.getName(inputSoul)));
        result.set(DataComponentsTypeRegistry.FACTOR_DATA, UmaFactorUtils.serializeData(stackList));
        return result;
    }

    public List<UmaFactorStack> createResultFactors(ItemStack inputSoul, int ranking) {
        @NotNull Stream<UmaFactor> status = UmaFactorRegistry.REGISTRY.stream().filter(fac -> fac.getFactorType() == FactorType.STATUS);
        long statusCount = UmaFactorRegistry.REGISTRY.stream().filter(fac -> fac.getFactorType() == FactorType.STATUS).count();
        StatusFactor statusFactor = (StatusFactor)status.skip(this.rand.nextLong(statusCount)).findFirst().orElse((UmaFactor)UmaFactorRegistry.SPEED_FACTOR.get());
        int statusProperty = 0;
        switch (statusFactor.getStatusType()) {
            case SPEED: {
                statusProperty = UmaSoulUtils.getProperty(inputSoul).speed();
                break;
            }
            case STAMINA: {
                statusProperty = UmaSoulUtils.getProperty(inputSoul).stamina();
                break;
            }
            case STRENGTH: {
                statusProperty = UmaSoulUtils.getProperty(inputSoul).strength();
                break;
            }
            case GUTS: {
                statusProperty = UmaSoulUtils.getProperty(inputSoul).guts();
                break;
            }
            case WISDOM: {
                statusProperty = UmaSoulUtils.getProperty(inputSoul).wisdom();
            }
        }
        int i = statusProperty > 19 ? 5 : (statusProperty > 10 ? 3 : 2);
        UmaFactorStack statusFactorStack = new UmaFactorStack(statusFactor, this.rand.nextInt(i) + 1);
        Stream<UmaFactor> extraStatus = UmaFactorRegistry.REGISTRY.stream().filter(fac -> fac.getFactorType() == FactorType.EXTRASTATUS);
        long extraStatusCount = UmaFactorRegistry.REGISTRY.stream().filter(fac -> fac.getFactorType() == FactorType.EXTRASTATUS).count();
        UmaFactor extraStatusFactor = extraStatus.skip(this.rand.nextLong(extraStatusCount)).findFirst().orElse((UmaFactor)UmaFactorRegistry.PHYSIQUE_FACTOR.get());
        UmaFactorStack extraStatusFactorStack = new UmaFactorStack(extraStatusFactor, this.rand.nextInt(ranking > 18 ? 3 : 2) + 1);
        UmaFactorStack uniqueFactor = new UmaFactorStack((UmaFactor)UmaFactorRegistry.UNIQUE_SKILL_FACTOR.get(), 1);
        uniqueFactor.getOrCreateTag().putString("skill", UmaSoulUtils.getSkills(inputSoul).get(0).toString());
        ArrayList stackList = Lists.newArrayList((Object[])new UmaFactorStack[]{statusFactorStack, extraStatusFactorStack, uniqueFactor});
        this.createOtherFactors(inputSoul, ranking, stackList);
        this.createSkillFactors(inputSoul, ranking, stackList);
        return stackList;
    }

    public void createSkillFactors(ItemStack inputSoul, int ranking, List<UmaFactorStack> stackList) {
        UmaSoulUtils.getSkills(inputSoul).stream().skip(1L).forEach(skillTag -> {
            if (skillTag != null && UmaSkillRegistry.REGISTRY.containsKey(skillTag)) {
                UmaSkill result = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skillTag);
                if (!result.isInheritable()) {
                    return;
                }
                int skillLevel = this.rand.nextInt(ranking > 19 ? 6 : 4);
                if (skillLevel == 0) {
                    return;
                }
                UmaFactorStack skillFactor = new UmaFactorStack((UmaFactor)UmaFactorRegistry.SKILL_FACTOR.get(), skillLevel);
                skillFactor.getOrCreateTag().putString("skill", skillTag.toString());
                stackList.add(skillFactor);
            }
        });
    }

    public void createOtherFactors(ItemStack inputSoul, int ranking, List<UmaFactorStack> stackList) {
        UmaFactorRegistry.REGISTRY.stream().filter(fac -> fac.getFactorType() == FactorType.OTHER && !(fac instanceof SkillFactor)).forEach(fac -> {
            int skillLevel = this.rand.nextInt(ranking > 19 ? 6 : 4);
            if (skillLevel == 0) {
                return;
            }
            UmaFactorStack skillFactor = new UmaFactorStack((UmaFactor)fac, skillLevel);
            stackList.add(skillFactor);
        });
    }

    public void slotsChanged(Container pInventory) {
        super.slotsChanged(pInventory);
        this.rand.setSeed(this.getFactorSeed().get());
        if (pInventory == this.inputSlots) {
            this.createResult();
        }
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((level, pos) -> this.clearContainer(pPlayer, this.inputSlots));
    }

    public boolean stillValid(Player pPlayer) {
        return (Boolean)this.access.evaluate((level, pos) -> !this.isValidBlock(level.getBlockState(pos)) ? false : pPlayer.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            int i;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != 0 ? pIndex >= 2 && pIndex < 38 && !this.moveItemStackTo(itemstack1, i = 0, 1, false) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public DataSlot getFactorSeed() {
        return this.factorSeed;
    }
}

