/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.SkillBookItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSkillUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class SkillLearningMenu
extends ItemCombinerMenu {
    public SkillLearningMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL);
    }

    public SkillLearningMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)ContainerRegistry.SKILL_LEARNING_TABLE.get(), pContainerId, pPlayerInventory, pAccess);
    }

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    private boolean hasResult() {
        ResourceLocation skillRL;
        ItemStack inputSoul = this.inputSlots.getItem(0);
        ItemStack inputSkill = this.inputSlots.getItem(1);
        if (this.isUmaSoul(inputSoul) && this.isSkillBook(inputSkill) && UmaSkillRegistry.REGISTRY.containsKey(skillRL = ((DataLocation)inputSkill.get(DataComponentsTypeRegistry.DATA_LOCATION)).name())) {
            ResourceLocation upperSkill = ((UmaSkill)UmaSkillRegistry.REGISTRY.get(skillRL)).getUpperSkill();
            if (upperSkill != null && UmaSkillUtils.hasLearnedSkill(inputSoul, upperSkill)) {
                return false;
            }
            if (!UmaSoulUtils.hasEmptySkillSlot(inputSoul) && UmaSkillUtils.getLowerSkillIndex(inputSkill, skillRL) == -1) {
                return false;
            }
            UmaSkill skill = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skillRL);
            boolean result = UmaSkillUtils.hasLearnedSkill(inputSoul, skillRL);
            return UmaSoulUtils.getProperty(inputSoul).wisdom() >= skill.getRequiredWisdom() && !result;
        }
        return false;
    }

    private boolean isUmaSoul(ItemStack stack) {
        if (stack.getItem() instanceof UmaSoulItem) {
            return stack.has(DataComponentsTypeRegistry.UMADATA_TRAINING);
        }
        return false;
    }

    private boolean isSkillBook(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SkillBookItem) {
            SkillBookItem skillbook = (SkillBookItem)item;
            return skillbook.getSkill(stack) != null;
        }
        return false;
    }

    protected void onTake(Player player, ItemStack resultStack) {
        resultStack.onCraftedBy(player.level(), player, resultStack.getCount());
        this.resultSlots.awardUsedRecipes(player, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.access.execute((level, pos) -> player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.0f));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.inputSlots.getItem(pIndex);
        itemstack.shrink(1);
        this.inputSlots.setItem(pIndex, itemstack);
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.is((Block)BlockRegistry.SKILL_LEARNING_TABLE.get());
    }

    public void createResult() {
        if (!this.hasResult()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            this.resultSlots.setItem(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack supportItem;
        Item item;
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack result = ItemStack.EMPTY;
        if (!input.isEmpty()) {
            result = input.copy();
        }
        if ((item = (supportItem = this.inputSlots.getItem(1)).getItem()) instanceof SkillBookItem) {
            SkillBookItem skillBook = (SkillBookItem)item;
            UmaSkillUtils.learnSkill(result, UmaSkillRegistry.REGISTRY.getKey((Object)skillBook.getSkill(supportItem)));
        }
        return result;
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.resultSlots && super.canTakeItemForPickAll(pStack, pSlot);
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, this::isUmaSoul).withSlot(1, 76, 47, this::isSkillBook).withResultSlot(2, 134, 47).build();
    }
}

