/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.entity.TrainingFacilityBlockEntity;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.training.SupportContainer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TrainingFacilityContainer
extends AbstractContainerMenu {
    public final TrainingFacilityBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData containerData;
    private final ContainerLevelAccess canInteractWithCallable;

    public TrainingFacilityContainer(int windowId, Inventory playerInventory, TrainingFacilityBlockEntity tileEntity, ContainerData cookingPotDataIn) {
        super((MenuType)ContainerRegistry.TRAINING_FACILITY.get(), windowId);
        int i;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.containerData = cookingPotDataIn;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        this.addSlot((Slot)new TrainingUmaSlot(tileEntity, (IItemHandler)this.inventory, 0, 80, 98));
        for (i = 1; i < 4; ++i) {
            this.addSlot((Slot)new TrainingSupportSlot(tileEntity, (IItemHandler)this.inventory, i, (i - 1) * 27 + 12, 19));
        }
        for (i = 4; i < 7; ++i) {
            this.addSlot((Slot)new TrainingSupportSlot(tileEntity, (IItemHandler)this.inventory, i, (i - 4) * 27 + 94, 19));
        }
        int startPlayerInvY = 120;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * 18, startPlayerInvY + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * 18, 178));
        }
        this.addDataSlots(cookingPotDataIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemStack = itemStack1.copy();
            if (index >= 0 && index < 7) {
                if (!this.moveItemStackTo(itemStack1, 7, 43, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack1, itemStack);
            } else if (index >= 7 && index < 43 && !this.moveItemStackTo(itemStack1, 0, 7, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemStack1);
        }
        return itemStack;
    }

    private static TrainingFacilityBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof TrainingFacilityBlockEntity) {
            return (TrainingFacilityBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public TrainingFacilityContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, TrainingFacilityContainer.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean stillValid(Player playerIn) {
        return TrainingFacilityContainer.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BlockRegistry.TRAINING_FACILITY.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressionScaled() {
        int i = this.containerData.get(0);
        return i != 0 ? i * 130 / 260 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAnimation() {
        int i = this.containerData.get(0);
        return i != 0 ? i % 4 : 0;
    }

    public static class TrainingUmaSlot
    extends SlotItemHandler {
        private final TrainingFacilityBlockEntity tileEntity;

        public TrainingUmaSlot(TrainingFacilityBlockEntity tileEntity, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.tileEntity = tileEntity;
        }

        public boolean mayPlace(ItemStack stack) {
            if (stack.is((Item)ItemRegistry.UMA_SOUL.get())) {
                for (int i = 1; i < 7; ++i) {
                    ItemStack other = this.getItemHandler().getStackInSlot(i);
                    if (other.isEmpty()) continue;
                    Item item = other.getItem();
                    if (item instanceof SupportContainer) {
                        SupportContainer support = (SupportContainer)item;
                        if (support.canSupport(this.tileEntity.getLevel(), other).test(stack)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class TrainingSupportSlot
    extends SlotItemHandler {
        private final TrainingFacilityBlockEntity tileEntity;

        public TrainingSupportSlot(TrainingFacilityBlockEntity tileEntity, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.tileEntity = tileEntity;
        }

        public boolean mayPlace(ItemStack stack) {
            Item item = stack.getItem();
            if (item instanceof SupportContainer) {
                SupportContainer support = (SupportContainer)item;
                ItemStack soul = this.getItemHandler().getStackInSlot(0);
                for (int i = 1; i < 7; ++i) {
                    ItemStack other = this.getItemHandler().getStackInSlot(i);
                    if (!soul.isEmpty() && !support.canSupport(this.tileEntity.getLevel(), stack).test(soul)) {
                        return false;
                    }
                    if (i == this.getSlotIndex() || other.isEmpty() || support.canSupport(this.tileEntity.getLevel(), stack).test(other)) continue;
                    return false;
                }
            }
            return true;
        }

        public int getMaxStackSize(ItemStack stack) {
            return 1;
        }
    }
}

