/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSkillUtils;

public class SkillFactor
extends UmaFactor {
    public SkillFactor() {
        super(FactorType.OTHER);
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        ResourceLocation skill = ResourceLocation.tryParse((String)stack.getOrCreateTag().getString("skill"));
        if (skill != null && UmaSkillRegistry.REGISTRY.containsKey(skill)) {
            UmaSkill result = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skill);
            if (!result.isInheritable()) {
                return;
            }
            Random rand = new Random();
            if ((double)rand.nextFloat() < (double)stack.getLevel() * 0.25) {
                UmaSkillUtils.learnSkill(soul, skill);
            }
        }
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        ResourceLocation skill = ResourceLocation.tryParse((String)stack.getOrCreateTag().getString("skill"));
        if (skill != null && UmaSkillRegistry.REGISTRY.containsKey(skill)) {
            UmaSkill result = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skill);
            return result.getDescription().copy().append(" ").append((Component)Component.translatable((String)("enchantment.level." + stack.getLevel())));
        }
        return super.getDescription(stack);
    }
}

