/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.umadata.UmaDataBasicStatus;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class StatusFactor
extends UmaFactor {
    private final UmaStatusUtils.StatusType statusType;

    public StatusFactor(UmaStatusUtils.StatusType status) {
        super(FactorType.STATUS);
        this.statusType = status;
    }

    public UmaStatusUtils.StatusType getStatusType() {
        return this.statusType;
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        switch (this.statusType) {
            case SPEED: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed() + stack.getLevel(), data.stamina(), data.strength(), data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).speed(), data.speed() + stack.getLevel()), data.stamina(), data.strength(), data.guts(), data.wisdom()));
                break;
            }
            case STAMINA: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina() + stack.getLevel(), data.strength(), data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).stamina(), data.stamina() + stack.getLevel()), data.strength(), data.guts(), data.wisdom()));
                break;
            }
            case STRENGTH: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength() + stack.getLevel(), data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).strength(), data.strength() + stack.getLevel()), data.guts(), data.wisdom()));
                break;
            }
            case GUTS: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts() + stack.getLevel(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).guts(), data.guts() + stack.getLevel()), data.wisdom()));
                break;
            }
            case WISDOM: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts(), data.wisdom() + stack.getLevel()));
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).wisdom(), data.wisdom() + stack.getLevel())));
            }
        }
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        return this.getFullDescription(stack.getLevel());
    }
}

