/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.umadata.UmaDataBasicStatus;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class WhiteStatusFactor
extends UmaFactor {
    private final UmaStatusUtils.StatusType statusType;

    public WhiteStatusFactor(UmaStatusUtils.StatusType status) {
        super(FactorType.OTHER);
        this.statusType = status;
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        int statusLevel = stack.getLevel();
        int maxStatusLevel = stack.getLevel();
        double chance = (double)stack.getLevel() * 0.25;
        Random rand = new Random();
        for (int roll = 0; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --maxStatusLevel;
        }
        int max = maxStatusLevel;
        for (int roll = 0; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --statusLevel;
        }
        int status = statusLevel;
        switch (this.statusType) {
            case SPEED: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed() + max, data.stamina(), data.strength(), data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).speed(), data.speed() + status), data.stamina(), data.strength(), data.guts(), data.wisdom()));
                break;
            }
            case STAMINA: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina() + max, data.strength(), data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).stamina(), data.stamina() + status), data.strength(), data.guts(), data.wisdom()));
                break;
            }
            case STRENGTH: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength() + max, data.guts(), data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).strength(), data.strength() + status), data.guts(), data.wisdom()));
                break;
            }
            case GUTS: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts() + max, data.wisdom()));
                soul.update(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaSoulUtils.getProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).guts(), data.guts() + status), data.wisdom()));
                break;
            }
            case WISDOM: {
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts(), data.wisdom() + max));
                soul.update(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaSoulUtils.getMaxProperty(soul), data -> new UmaDataBasicStatus(data.speed(), data.stamina(), data.strength(), data.guts(), Math.min(((UmaDataBasicStatus)soul.get(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS)).wisdom(), data.wisdom() + status)));
            }
        }
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        return this.getFullDescription(stack.getLevel());
    }
}

