/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.training;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.TrainingSupportRegistry;
import net.tracen.umapyoi.registry.training.SupportStack;

public class TrainingSupport {
    private String descriptionId;
    public static final Codec<TrainingSupport> CODEC = ResourceLocation.CODEC.xmap(loc -> (TrainingSupport)TrainingSupportRegistry.REGISTRY.get(loc), instance -> TrainingSupportRegistry.REGISTRY.getKey(instance));
    public static final ResourceKey<Registry<TrainingSupport>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"umapyoi", (String)"training_support"));

    public boolean applySupport(ItemStack soul, SupportStack stack) {
        return true;
    }

    public String toString() {
        return TrainingSupportRegistry.REGISTRY.getKey((Object)this).toString();
    }

    public Component getDescription() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public Component getDescription(SupportStack stack) {
        return this.getFullDescription(stack.getLevel());
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"support", (ResourceLocation)TrainingSupportRegistry.REGISTRY.getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullDescription(int pLevel) {
        MutableComponent mutablecomponent = Component.translatable((String)this.getDescriptionId());
        mutablecomponent.withStyle(ChatFormatting.GRAY);
        mutablecomponent.append(" ").append((Component)Component.translatable((String)("enchantment.level." + pLevel)));
        return mutablecomponent;
    }
}

