/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.registry.TrainingSupportRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.TrainingSupport;
import net.tracen.umapyoi.registry.training.card.SupportEntry;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaSkillUtils {
    public static SupportStack getSkillSupport(UmaSkill skill) {
        if (skill == null) {
            return SupportStack.EMPTY;
        }
        SupportStack result = new SupportStack((TrainingSupport)TrainingSupportRegistry.SKILL_SUPPORT.get(), 1);
        result.getOrCreateTag().putString("skill", UmaSkillRegistry.REGISTRY.getKey((Object)skill).toString());
        return result;
    }

    public static SupportEntry getSkillSupportEnrty(ResourceLocation skill) {
        if (skill == null) {
            return null;
        }
        SupportEntry result = new SupportEntry(TrainingSupportRegistry.SKILL_SUPPORT.getId(), 1);
        result.getOrCreateTag().putString("skill", skill.toString());
        return result;
    }

    public static ItemStack getSkillBook(UmaSkill skill) {
        if (skill == null) {
            return ItemStack.EMPTY;
        }
        ItemStack result = new ItemStack((ItemLike)ItemRegistry.SKILL_BOOK.get());
        result.update(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(UmaSkillRegistry.BASIC_PACE.getId()), loc -> new DataLocation(UmaSkillRegistry.REGISTRY.getKey((Object)skill)));
        return result;
    }

    public static void syncActionPoint(ItemStack stack) {
        UmaSoulUtils.setActionPoint(stack, UmaSoulUtils.getMaxActionPoint(stack));
    }

    public static void learnSkill(ItemStack stack, ResourceLocation skill) {
        if (!UmaSoulUtils.hasEmptySkillSlot(stack)) {
            return;
        }
        if (skill != null && UmaSkillRegistry.REGISTRY.containsKey(skill)) {
            UmaSkill skillItem = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skill);
            if (skillItem.getUpperSkill() != null && UmaSkillUtils.hasLearnedSkill(stack, skillItem.getUpperSkill())) {
                return;
            }
            int lowerSkillIndex = UmaSkillUtils.getLowerSkillIndex(stack, skill);
            if (lowerSkillIndex != -1) {
                UmaSoulUtils.setSkill(stack, lowerSkillIndex, skill);
            }
            if (!UmaSkillUtils.hasLearnedSkill(stack, skill)) {
                UmaSoulUtils.addSkill(stack, skill);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new SkillEvent.LearnSkillEvent(skill, stack));
    }

    public static boolean hasLearnedSkill(ItemStack stack, ResourceLocation skill) {
        List<ResourceLocation> skills = UmaSoulUtils.getSkills(stack);
        return skills.contains(skill);
    }

    public static int getLowerSkillIndex(ItemStack stack, ResourceLocation skill) {
        List<ResourceLocation> skills = UmaSoulUtils.getSkills(stack);
        UmaSkill target = null;
        for (int i = 0; i < skills.size(); ++i) {
            target = (UmaSkill)UmaSkillRegistry.REGISTRY.get(skills.get(i));
            if (target.getUpperSkill() == null || target == null || !target.getUpperSkill().equals((Object)skill)) continue;
            return i;
        }
        return -1;
    }
}

