/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.api;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tracen.umapyoi.client.renderer.AbstractSuitRenderer;
import net.tracen.umapyoi.events.FindUmaSoulEvent;
import net.tracen.umapyoi.item.UmaCostumeItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.item.UmaSuitItem;
import net.tracen.umapyoi.registry.cosmetics.CosmeticData;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class UmapyoiAPI {
    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getRenderingUmaSoul(LivingEntity entity) {
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent()) {
            ICuriosItemHandler itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
            if (itemHandler == null) {
                return ItemStack.f_41583_;
            }
            if (itemHandler.getStacksHandler("uma_soul").isPresent()) {
                ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_soul").orElse(null);
                if (!((Boolean)stacksHandler.getRenders().get(0)).booleanValue()) {
                    return ItemStack.f_41583_;
                }
                ItemStack cosmeticStack = UmapyoiAPI.getFirstUmaSoul(stacksHandler.getCosmeticStacks());
                if (!cosmeticStack.m_41619_()) {
                    return cosmeticStack;
                }
                return UmapyoiAPI.getFirstUmaSoul(stacksHandler.getStacks());
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getUmaSoul(LivingEntity entity) {
        FindUmaSoulEvent.Pre preEvent = new FindUmaSoulEvent.Pre(entity);
        ItemStack result = ItemStack.f_41583_;
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent) && !(result = preEvent.getUmaSoul()).m_41619_()) {
            return result;
        }
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent()) {
            ICuriosItemHandler itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
            if (itemHandler == null) {
                return ItemStack.f_41583_;
            }
            if (itemHandler.getStacksHandler("uma_soul").isPresent()) {
                ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_soul").orElse(null);
                result = UmapyoiAPI.getFirstUmaSoul(stacksHandler.getStacks());
            }
        }
        FindUmaSoulEvent.Post postEvent = new FindUmaSoulEvent.Post(entity, result);
        return postEvent.getUmaSoul();
    }

    private static ItemStack getFirstUmaSoul(IDynamicStackHandler stackHandler) {
        if (stackHandler.getSlots() <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = stackHandler.getStackInSlot(0);
        if (stackInSlot.m_41720_() instanceof UmaSoulItem) {
            return stackInSlot;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getUmaSuit(LivingEntity entity) {
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent()) {
            ICuriosItemHandler itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
            if (itemHandler == null) {
                return ItemStack.f_41583_;
            }
            if (itemHandler.getStacksHandler("uma_suit").isPresent()) {
                ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_suit").orElse(null);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (stackHandler.getSlots() <= 0) {
                    return ItemStack.f_41583_;
                }
                ItemStack stackInSlot = stackHandler.getStackInSlot(0);
                if (stackInSlot.m_41720_() instanceof UmaSuitItem || stackInSlot.m_41720_() instanceof UmaCostumeItem) {
                    return stackInSlot;
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isUmaSuitRendering(LivingEntity player) {
        if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            ICuriosItemHandler itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
            if (itemHandler == null) {
                return false;
            }
            if (itemHandler.getStacksHandler("uma_suit").isPresent()) {
                ICurioStacksHandler stacksHandler = itemHandler.getStacksHandler("uma_suit").orElse(null);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (stackHandler.getSlots() <= 0) {
                    return false;
                }
                if (!stackHandler.getStackInSlot(0).m_41619_()) {
                    return (Boolean)stacksHandler.getRenders().get(0);
                }
            }
        }
        return false;
    }

    public static boolean isUmaSuitHasHat(LivingEntity player) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)UmapyoiAPI.getUmaSuit(player).m_41720_());
        if (renderer.isPresent() && (t = renderer.get()) instanceof AbstractSuitRenderer) {
            AbstractSuitRenderer suit = (AbstractSuitRenderer)t;
            return !suit.getBaseModel().getChild("hat").isEmpty();
        }
        return false;
    }

    public static boolean isSpecifyUmamusumeSoul(ItemStack soul, ResourceLocation name) {
        return UmaSoulUtils.getName(soul).equals((Object)name);
    }

    public static boolean isSpecifyUmamusume(ItemStack soul, ResourceLocation identifier, Level level) {
        return ((UmaData)UmapyoiAPI.getUmaDataRegistry(level).m_7745_(UmaSoulUtils.getName(soul))).getIdentifier().equals((Object)identifier);
    }

    public static Registry<UmaData> getUmaDataRegistry(Level level) {
        if (level.m_5776_()) {
            return ClientUtils.getClientUmaDataRegistry();
        }
        return level.m_9598_().m_175515_(UmaData.REGISTRY_KEY);
    }

    public static Registry<SupportCard> getSupportCardRegistry(Level level) {
        if (level.m_5776_()) {
            return ClientUtils.getClientSupportCardRegistry();
        }
        return level.m_9598_().m_175515_(SupportCard.REGISTRY_KEY);
    }

    public static HolderLookup.RegistryLookup<UmaData> getUmaDataRegistry(HolderLookup.Provider provider) {
        return provider.m_255025_(UmaData.REGISTRY_KEY);
    }

    public static HolderLookup.RegistryLookup<SupportCard> getSupportCardRegistry(HolderLookup.Provider provider) {
        return provider.m_255025_(SupportCard.REGISTRY_KEY);
    }

    public static HolderLookup.RegistryLookup<CosmeticData> getCosmeticDataRegistry(HolderLookup.Provider provider) {
        return provider.m_255025_(CosmeticData.REGISTRY_KEY);
    }
}

