/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.model;

import cn.mcmod_mmf.mmlib.client.model.BedrockHumanoidModel;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPart;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.data.tag.UmapyoiUmaDataTags;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaPlayerModel<T extends LivingEntity>
extends BedrockHumanoidModel<T> {
    public BedrockPart rightArmDown;
    public BedrockPart leftArmDown;
    public BedrockPart rightLegDown;
    public BedrockPart leftLegDown;
    public BedrockPart rightEar;
    public BedrockPart leftEar;
    public BedrockPart rightEarHideParts;
    public BedrockPart leftEarHideParts;
    public BedrockPart rightFoot;
    public BedrockPart leftFoot;
    public BedrockPart rightLegHideParts;
    public BedrockPart leftLegHideParts;
    public BedrockPart hat = new BedrockPart();
    public BedrockPart hideParts;
    public BedrockPart tail;
    public BedrockPart tailDown;
    public BedrockPart cape;
    public List<BedrockPart> longHairParts = Lists.newArrayList();

    public UmaPlayerModel() {
    }

    public UmaPlayerModel(BedrockModelPOJO pojo) {
        super(pojo);
    }

    public void loadModel(BedrockModelPOJO pojo) {
        super.loadModel(pojo);
        this.rightArmDown = this.getChild("right_arm_down");
        this.leftArmDown = this.getChild("left_arm_down");
        this.rightLegDown = this.getChild("right_leg_down");
        this.leftLegDown = this.getChild("left_leg_down");
        this.rightEar = this.getChild("right_ear");
        this.leftEar = this.getChild("left_ear");
        this.rightFoot = this.getChild("right_foot");
        this.leftFoot = this.getChild("left_foot");
        this.hat = this.getChild("hat") != null ? this.getChild("hat") : new BedrockPart();
        this.cape = this.getChild("cape") != null ? this.getChild("cape") : new BedrockPart();
        this.hideParts = this.getChild("hide_parts") != null ? this.getChild("hide_parts") : new BedrockPart();
        this.rightEarHideParts = this.getChild("right_earmuffs");
        this.leftEarHideParts = this.getChild("left_earmuffs");
        this.rightLegHideParts = this.getChild("right_leg_hide_parts") != null ? this.getChild("right_leg_hide_parts") : new BedrockPart();
        this.leftLegHideParts = this.getChild("left_leg_hide_parts") != null ? this.getChild("left_leg_hide_parts") : new BedrockPart();
        this.tail = this.getChild("tail");
        this.tailDown = this.getChild("tail_down");
        this.longHairParts = Lists.newArrayList();
        this.getModelMap().forEach((name, part) -> {
            if (name.startsWith("long_hair_") || name.equals("long_hair")) {
                this.longHairParts.add((BedrockPart)part);
            }
        });
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entityIn, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (entityIn instanceof ArmorStand) {
            ArmorStand entityarmorstand = (ArmorStand)entityIn;
            this.head.xRot = (float)Math.PI / 180 * entityarmorstand.m_31680_().m_123156_();
            this.head.yRot = (float)Math.PI / 180 * entityarmorstand.m_31680_().m_123157_();
            this.head.zRot = (float)Math.PI / 180 * entityarmorstand.m_31680_().m_123158_();
            this.head.setPos(0.0f, 1.0f, 0.0f);
            this.body.xRot = (float)Math.PI / 180 * entityarmorstand.m_31685_().m_123156_();
            this.body.yRot = (float)Math.PI / 180 * entityarmorstand.m_31685_().m_123157_();
            this.body.zRot = (float)Math.PI / 180 * entityarmorstand.m_31685_().m_123158_();
            this.leftArm.xRot = (float)Math.PI / 180 * entityarmorstand.m_31688_().m_123156_();
            this.leftArm.yRot = (float)Math.PI / 180 * entityarmorstand.m_31688_().m_123157_();
            this.leftArm.zRot = (float)Math.PI / 180 * entityarmorstand.m_31688_().m_123158_();
            this.rightArm.xRot = (float)Math.PI / 180 * entityarmorstand.m_31689_().m_123156_();
            this.rightArm.yRot = (float)Math.PI / 180 * entityarmorstand.m_31689_().m_123157_();
            this.rightArm.zRot = (float)Math.PI / 180 * entityarmorstand.m_31689_().m_123158_();
            this.leftLeg.xRot = (float)Math.PI / 180 * entityarmorstand.m_31691_().m_123156_();
            this.leftLeg.yRot = (float)Math.PI / 180 * entityarmorstand.m_31691_().m_123157_();
            this.leftLeg.zRot = (float)Math.PI / 180 * entityarmorstand.m_31691_().m_123158_();
            this.leftLeg.setPos(1.9f, 11.0f, 0.0f);
            this.rightLeg.xRot = (float)Math.PI / 180 * entityarmorstand.m_31694_().m_123156_();
            this.rightLeg.yRot = (float)Math.PI / 180 * entityarmorstand.m_31694_().m_123157_();
            this.rightLeg.zRot = (float)Math.PI / 180 * entityarmorstand.m_31694_().m_123158_();
            this.rightLeg.setPos(-1.9f, 11.0f, 0.0f);
        } else {
            this.tail.copyFrom(this.body);
            if (this.crouching) {
                this.tail.xRot = 1.0f + pLimbSwingAmount * 0.5f;
                this.tail.z = 3.125f;
                this.tail.y = 11.0f;
                this.cape.xRot = 1.0f + pLimbSwingAmount * 0.5f;
            } else {
                this.tail.xRot = pLimbSwingAmount * 1.0f;
                this.tail.z = 1.75f;
                this.tail.y = 8.0f;
                this.cape.xRot = pLimbSwingAmount * 1.0f;
            }
            if (this.head.xRot < 0.0f) {
                this.longHairParts.forEach(part -> {
                    part.xRot = -this.head.xRot;
                });
            } else {
                this.longHairParts.forEach(part -> {
                    part.xRot = 0.0f;
                });
            }
            ItemStack renderingUmaSoul = UmapyoiAPI.getRenderingUmaSoul(entityIn);
            boolean isStucked = ((Holder.Reference)ClientUtils.getClientUmaDataRegistry().m_203636_(ResourceKey.m_135785_(UmaData.REGISTRY_KEY, (ResourceLocation)UmaSoulUtils.getName(renderingUmaSoul))).get()).m_203656_(UmapyoiUmaDataTags.STUCK_MODEL);
            if (!isStucked) {
                this.animationEarTail(entityIn, pAgeInTicks);
            }
        }
        this.hat.copyFrom(this.head);
    }

    private void animationEarTail(T entityIn, float pAgeInTicks) {
        int ears_reminder = (int)((pAgeInTicks + (float)(Math.abs(entityIn.m_20148_().getLeastSignificantBits()) % 10L)) % (float)((Integer)UmapyoiConfig.EAR_ANIMATION_INTERVAL.get()).intValue());
        int tail_reminder = (int)((pAgeInTicks + (float)(Math.abs(entityIn.m_20148_().getLeastSignificantBits()) % 10L)) % (float)((Integer)UmapyoiConfig.TAIL_ANIMATION_INTERVAL.get()).intValue());
        float earRot = Mth.m_14089_((float)ears_reminder) * 0.125f;
        if (0 < ears_reminder && ears_reminder < 8) {
            if (this.leftEarHideParts != null) {
                this.leftEarHideParts.zRot = earRot;
            }
            if (this.rightEarHideParts != null) {
                this.rightEarHideParts.zRot = -earRot;
            }
            this.leftEar.zRot = earRot;
            this.rightEar.zRot = -earRot;
        } else {
            if (this.leftEarHideParts != null) {
                this.leftEarHideParts.zRot = 0.0f;
            }
            if (this.rightEarHideParts != null) {
                this.rightEarHideParts.zRot = 0.0f;
            }
            this.leftEar.zRot = 0.0f;
            this.rightEar.zRot = 0.0f;
        }
        if (0 < tail_reminder && tail_reminder < 8) {
            this.tail.zRot = -Mth.m_14089_((float)(pAgeInTicks * 0.7f)) * 0.5f;
            this.tail.yRot = Mth.m_14089_((float)(pAgeInTicks * 0.7f)) * 0.5f;
        } else {
            this.tail.zRot = 0.0f;
            this.tail.yRot = 0.0f;
        }
    }

    public void setModelProperties(LivingEntity player) {
        boolean shouldSit;
        this.f_102609_ = shouldSit = player.m_20159_() && player.m_20202_() != null && player.m_20202_().shouldRiderSit();
        if (player.m_5833_()) {
            this.setAllVisible(false);
            this.head.visible = true;
        } else {
            this.setAllVisible(true);
            this.crouching = player.m_6047_();
            if (((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && !((Boolean)UmapyoiConfig.HIDE_PARTS_RENDER.get()).booleanValue()) {
                if (!player.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                    this.hideHat();
                } else {
                    this.showHat();
                }
                if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_() && !(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem)) {
                    this.hideParts.visible = false;
                    this.cape.visible = false;
                } else {
                    this.hideParts.visible = true;
                    this.cape.visible = true;
                }
                if (!player.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                    this.rightLegHideParts.visible = false;
                    this.leftLegHideParts.visible = false;
                } else {
                    this.rightLegHideParts.visible = true;
                    this.leftLegHideParts.visible = true;
                }
                if (!player.m_6844_(EquipmentSlot.FEET).m_41619_()) {
                    this.rightFoot.visible = false;
                    this.leftFoot.visible = false;
                } else {
                    this.rightFoot.visible = true;
                    this.leftFoot.visible = true;
                }
            }
            this.showEars();
        }
    }

    public void showEars() {
        if (this.hat.visible) {
            if (this.leftEarHideParts != null && !this.leftEarHideParts.isEmpty()) {
                this.leftEar.visible = false;
            }
            if (this.rightEarHideParts != null && !this.rightEarHideParts.isEmpty()) {
                this.rightEar.visible = false;
            }
        } else {
            if (this.leftEarHideParts != null && !this.leftEarHideParts.isEmpty()) {
                this.leftEar.visible = true;
            }
            if (this.rightEarHideParts != null && !this.rightEarHideParts.isEmpty()) {
                this.rightEar.visible = true;
            }
        }
    }

    public void setAllVisible(boolean pVisible) {
        super.setAllVisible(pVisible);
        this.hat.visible = pVisible;
        this.cape.visible = pVisible;
        this.tail.visible = pVisible;
    }

    public void copyAnim(BedrockPart part, ModelPart old_part) {
        part.xRot = old_part.f_104203_;
        part.yRot = old_part.f_104204_;
        part.zRot = old_part.f_104205_;
        part.x = old_part.f_104200_;
        if (part == this.leftArm) {
            part.x -= 1.0f;
        }
        if (part == this.rightArm) {
            part.x += 1.0f;
        }
        if (part == this.leftLeg) {
            part.x -= 0.125f;
        }
        if (part == this.rightLeg) {
            part.x += 0.125f;
        }
        part.y = old_part.f_104201_;
        part.z = old_part.f_104202_;
        if (part == this.leftLeg) {
            part.z -= 0.125f;
        }
        if (part == this.rightLeg) {
            part.z -= 0.125f;
        }
    }

    public void showHat() {
        this.hat.visible = true;
    }

    public void hideHat() {
        this.hat.visible = false;
    }
}

