/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.compat.jei.JEIPlugin;
import net.tracen.umapyoi.compat.jei.recipes.JEISimpleRecipe;
import net.tracen.umapyoi.item.ItemRegistry;

public class JEIGachaCategory
implements IRecipeCategory<JEISimpleRecipe> {
    private final Component title = Component.m_237115_((String)"umapyoi.jei.gacha");
    private final IDrawable background;
    private final IDrawable chancedSlot;
    private final IDrawable icon;

    public JEIGachaCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("umapyoi", "textures/gui/jei_compat.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 93, 46);
        this.chancedSlot = helper.createDrawable(backgroundImage, 93, 0, 18, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.UMA_PEDESTAL.get()));
    }

    public RecipeType<JEISimpleRecipe> getRecipeType() {
        return JEIPlugin.GACHA_JEI_TYPE;
    }

    public void draw(JEISimpleRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Optional outputStack = recipeSlotsView.findSlotByName("outputSlot").flatMap(slot -> slot.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK));
        outputStack.ifPresent(output -> {
            if (output.m_150930_((Item)ItemRegistry.SUPPORT_CARD.get())) {
                Minecraft minecraft = Minecraft.m_91087_();
                Font fontRenderer = minecraft.f_91062_;
                MutableComponent needBookText = Component.m_237115_((String)"umapyoi.jei.gacha.need_book");
                guiGraphics.m_280430_(fontRenderer, (Component)needBookText, 46 - fontRenderer.m_92724_(needBookText.m_7532_()) / 2, 36, 0xFEFEFE);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
        if (recipe.getOutputs().size() > 1) {
            this.chancedSlot.draw(guiGraphics, 62, 14);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JEISimpleRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 14, 15).setSlotName("inputSlot").addItemStacks(recipe.getInputs());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 15).setSlotName("outputSlot").addItemStacks(recipe.getOutputs());
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

