/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.client.model.UmaCostumeModelUtils;
import net.tracen.umapyoi.client.model.UmaPlayerModel;
import net.tracen.umapyoi.data.tag.UmapyoiCostumeDataTags;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.events.client.RenderingUmaSoulEvent;
import net.tracen.umapyoi.item.UmaCostumeItem;
import net.tracen.umapyoi.registry.cosmetics.CosmeticData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static Map<EquipmentSlot, ItemStack> armor;
    private static final UmaPlayerModel<LivingEntity> baseModel;

    @SubscribeEvent
    public static void preUmaSoulRendering(RenderingUmaSoulEvent.Pre event) {
        LivingEntity entity = event.getWearer();
        UmaPlayerModel<LivingEntity> model = event.getModel();
        boolean hideHair = false;
        if (UmapyoiAPI.isUmaSuitRendering(entity)) {
            model.setAllVisible(false);
            model.head.visible = true;
            model.tail.visible = true;
            if (UmapyoiAPI.isUmaSuitHasHat(entity)) {
                ResourceLocation loc = UmaCostumeItem.getCostumeID(UmapyoiAPI.getUmaSuit(entity));
                Optional costumeData = ClientUtils.getClientCosmeticDataRegistry().m_203636_(ResourceKey.m_135785_(CosmeticData.REGISTRY_KEY, (ResourceLocation)loc));
                if (((Holder.Reference)costumeData.get()).m_203656_(UmapyoiCostumeDataTags.HAT_HIDEHAIR)) {
                    hideHair = true;
                    model.longHairParts.forEach(part -> {
                        part.visible = false;
                    });
                } else {
                    model.longHairParts.forEach(part -> {
                        part.visible = true;
                    });
                }
                model.hideHat();
            } else {
                model.showHat();
            }
        } else {
            model.setAllVisible(true);
        }
        if (hideHair) {
            model.longHairParts.forEach(part -> {
                part.visible = false;
            });
        } else {
            model.longHairParts.forEach(part -> {
                part.visible = true;
            });
        }
        model.showEars();
    }

    @SubscribeEvent
    public static <T extends LivingEntity, M extends EntityModel<T>> void onPlayerRendering(RenderLivingEvent.Pre<T, M> event) {
        EquipmentSlot[] equipmentSlotArray;
        LivingEntity player = event.getEntity();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul(event.getEntity());
        if (!umasoul.m_41619_() && (equipmentSlotArray = event.getRenderer().m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoid = (HumanoidModel)equipmentSlotArray;
            humanoid.m_8009_(false);
            if (!((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && !umasoul.m_41619_()) {
                armor = Maps.newHashMap();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (slot.m_20743_() == EquipmentSlot.Type.HAND) continue;
                    ItemStack itemBySlot = player.m_6844_(slot);
                    armor.put(slot, itemBySlot);
                    boolean renderElytry = (Boolean)UmapyoiConfig.ELYTRA_RENDER.get() != false && itemBySlot.m_41720_() instanceof ElytraItem;
                    boolean shouldRender = itemBySlot.m_204117_(UmapyoiItemTags.SHOULD_RENDER);
                    if (renderElytry || shouldRender) {
                        player.m_8061_(slot, itemBySlot);
                        continue;
                    }
                    player.m_8061_(slot, ItemStack.f_41583_);
                }
            }
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity, M extends EntityModel<T>> void onPlayerRenderingPost(RenderLivingEvent.Post<T, M> event) {
        LivingEntity player = event.getEntity();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul(event.getEntity());
        if (!((Boolean)UmapyoiConfig.VANILLA_ARMOR_RENDER.get()).booleanValue() && armor != null && !umasoul.m_41619_()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() == EquipmentSlot.Type.HAND) continue;
                player.m_8061_(slot, armor.get(slot));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerArmRendering(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        ItemStack umasoul = UmapyoiAPI.getRenderingUmaSoul((LivingEntity)player);
        ItemStack umasuit = UmapyoiAPI.getUmaSuit((LivingEntity)player);
        if (!umasoul.m_41619_()) {
            ResourceLocation name = UmaSoulUtils.getName(umasoul);
            VertexConsumer vertexconsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110473_((ResourceLocation)ClientEvents.getTexture(name)));
            BedrockModelPOJO pojo = ClientUtil.getModelPOJO((ResourceLocation)name);
            if (!umasuit.m_41619_()) {
                boolean tanned = ClientUtils.isTannedSkin(umasoul);
                vertexconsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110473_((ResourceLocation)UmaCostumeModelUtils.getCostumeTexture(umasuit, tanned)));
                pojo = ClientUtil.getModelPOJO((ResourceLocation)UmaCostumeModelUtils.getCostumeModel(umasuit));
            }
            ClientEvents.renderArmModel(event, name, vertexconsumer, pojo);
            event.setCanceled(true);
        }
    }

    private static void renderArmModel(RenderArmEvent event, ResourceLocation name, VertexConsumer vertexconsumer, BedrockModelPOJO pojo) {
        if (baseModel.needRefresh(pojo)) {
            baseModel.loadModel(pojo);
        }
        baseModel.setModelProperties((LivingEntity)event.getPlayer());
        ClientEvents.baseModel.f_102608_ = 0.0f;
        ClientEvents.baseModel.crouching = false;
        ClientEvents.baseModel.swimAmount = 0.0f;
        baseModel.setupAnim((LivingEntity)event.getPlayer(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (event.getArm() == HumanoidArm.RIGHT) {
            ClientEvents.baseModel.rightArm.xRot = 0.0f;
            ClientEvents.baseModel.rightArm.x -= 1.0f;
            ClientEvents.baseModel.rightArm.render(event.getPoseStack(), vertexconsumer, event.getPackedLight(), OverlayTexture.f_118083_);
            if (baseModel.isEmissive()) {
                VertexConsumer emissiveConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_234338_((ResourceLocation)ClientUtils.getEmissiveTexture(name)));
                ClientEvents.baseModel.rightArm.renderEmissive(event.getPoseStack(), emissiveConsumer, event.getPackedLight(), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            ClientEvents.baseModel.rightArm.x += 1.0f;
        } else {
            ClientEvents.baseModel.leftArm.xRot = 0.0f;
            ClientEvents.baseModel.leftArm.x += 1.0f;
            ClientEvents.baseModel.leftArm.render(event.getPoseStack(), vertexconsumer, event.getPackedLight(), OverlayTexture.f_118083_);
            if (baseModel.isEmissive()) {
                VertexConsumer emissiveConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_234338_((ResourceLocation)ClientUtils.getEmissiveTexture(name)));
                ClientEvents.baseModel.leftArm.renderEmissive(event.getPoseStack(), emissiveConsumer, event.getPackedLight(), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            ClientEvents.baseModel.leftArm.x -= 1.0f;
        }
    }

    private static ResourceLocation getTexture(ResourceLocation name) {
        return new ResourceLocation(name.m_135827_(), "textures/model/" + name.m_135815_() + ".png");
    }

    static {
        baseModel = new UmaPlayerModel();
    }
}

