/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.SupportType;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class SupportCardItem
extends Item
implements SupportContainer {
    private static final Comparator<Holder.Reference<SupportCard>> COMPARATOR = new CardDataComparator();

    public SupportCardItem() {
        super(Umapyoi.defaultItemProperties().m_41487_(1));
    }

    public static Stream<Holder.Reference<SupportCard>> sortedCardDataList(HolderLookup.Provider provider) {
        return UmapyoiAPI.getSupportCardRegistry(provider).m_214062_().sorted(COMPARATOR);
    }

    public ItemStack m_7968_() {
        ItemStack result = super.m_7968_();
        result.m_41784_().m_128359_("support_card", "umapyoi:blank_card");
        result.m_41784_().m_128359_("ranking", GachaRanking.R.name().toLowerCase());
        result.m_41784_().m_128405_("maxDamage", 0);
        return result;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.m_41784_().m_128451_("maxDamage");
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_204117_(UmapyoiItemTags.HORSESHOE) || super.m_6832_(pToRepair, pRepair);
    }

    public Rarity m_41460_(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        return ranking == GachaRanking.SSR ? Rarity.EPIC : (ranking == GachaRanking.SR ? Rarity.UNCOMMON : Rarity.COMMON);
    }

    public String m_5671_(ItemStack pStack) {
        return Util.m_137492_((String)"support_card", (ResourceLocation)this.getSupportCardID(pStack)) + ".name";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        ResourceLocation cardID = this.getSupportCardID(stack);
        if (this.isEmptyCard(level, cardID)) {
            return;
        }
        if (Screen.m_96638_() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.supports").m_130940_(ChatFormatting.AQUA));
            this.getSupports(level, stack).forEach(support -> tooltip.add((Component)support.getDescription().m_6881_().m_130940_(ChatFormatting.GRAY)));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.support_card.press_shift_for_supports").m_130940_(ChatFormatting.AQUA));
        }
        List<ResourceLocation> supporters = ((SupportCard)ClientUtils.getClientSupportCardRegistry().m_7745_(cardID)).getSupporters();
        if (!supporters.isEmpty()) {
            if (Screen.m_96637_() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.supporters").m_130940_(ChatFormatting.AQUA));
                supporters.forEach(name -> tooltip.add((Component)UmaSoulUtils.getTranslatedUmaName(name).m_6881_().m_130940_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.support_card.press_ctrl_for_supporters").m_130940_(ChatFormatting.AQUA));
            }
        }
    }

    public ResourceLocation getSupportCardID(ItemStack stack) {
        if (stack.m_41784_().m_128441_("support_card")) {
            return ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_("support_card"));
        }
        return SupportCard.EMPTY_ID;
    }

    public SupportCard getSupportCard(Level level, ItemStack stack) {
        ResourceLocation cardID = this.getSupportCardID(stack);
        if (this.isEmptyCard(level, cardID)) {
            return SupportCard.EMPTY;
        }
        return (SupportCard)UmapyoiAPI.getSupportCardRegistry(level).m_7745_(cardID);
    }

    private boolean isEmptyCard(Level level, ResourceLocation cardID) {
        return level == null || cardID.equals((Object)SupportCard.EMPTY_ID) || !UmapyoiAPI.getSupportCardRegistry(level).m_7804_(cardID);
    }

    @Override
    public boolean isConsumable(Level level, ItemStack stack) {
        return false;
    }

    @Override
    public GachaRanking getSupportLevel(Level level, ItemStack stack) {
        if (level == null) {
            return GachaRanking.R;
        }
        return this.getSupportCard(level, stack).getGachaRanking();
    }

    @Override
    public SupportType getSupportType(Level level, ItemStack stack) {
        return this.getSupportCard(level, stack).getSupportType();
    }

    @Override
    public List<SupportStack> getSupports(Level level, ItemStack stack) {
        return (List)Suppliers.memoize(this.getSupportCard(level, stack)::getSupportStacks).get();
    }

    @Override
    public Predicate<ItemStack> canSupport(Level level, ItemStack stack) {
        return itemstack -> {
            if (level == null) {
                return false;
            }
            Item item = itemstack.m_41720_();
            if (item instanceof UmaSoulItem) {
                UmaData data = (UmaData)UmapyoiAPI.getUmaDataRegistry(level).m_7745_(UmaSoulUtils.getName(itemstack));
                return !this.getSupportCard(level, stack).getSupporters().contains(data.getIdentifier());
            }
            if (item instanceof SupportCardItem) {
                return this.checkSupports(level, stack, (ItemStack)itemstack);
            }
            return true;
        };
    }

    public boolean checkSupports(Level level, ItemStack stack, ItemStack other) {
        if (stack.m_41720_() instanceof SupportCardItem) {
            ResourceLocation otherCardID;
            ResourceLocation supportCardID = this.getSupportCardID(stack);
            if (supportCardID.equals((Object)(otherCardID = this.getSupportCardID(other)))) {
                return false;
            }
            SupportCard supportCard = this.getSupportCard(level, stack);
            SupportCard otherCard = this.getSupportCard(level, other);
            for (ResourceLocation name : supportCard.getSupporters()) {
                if (!otherCard.getSupporters().contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    private static class CardDataComparator
    implements Comparator<Holder.Reference<SupportCard>> {
        private CardDataComparator() {
        }

        @Override
        public int compare(Holder.Reference<SupportCard> left, Holder.Reference<SupportCard> right) {
            GachaRanking rightRanking;
            GachaRanking leftRanking = ((SupportCard)left.m_203334_()).getGachaRanking();
            if (leftRanking == (rightRanking = ((SupportCard)right.m_203334_()).getGachaRanking())) {
                String leftName = left.m_205785_().m_135782_().toString();
                String rightName = right.m_205785_().m_135782_().toString();
                return leftName.compareToIgnoreCase(rightName);
            }
            return leftRanking.compareTo(rightRanking);
        }
    }
}

