/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.cosmetics;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.tracen.umapyoi.utils.ClientUtils;

public record CosmeticData(ResourceLocation model, Optional<ResourceLocation> flatModel, Optional<ResourceLocation> texture, Optional<ResourceLocation> flatTexture) {
    public static final Codec<CosmeticData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(CosmeticData::model), (App)ResourceLocation.f_135803_.optionalFieldOf("flatModel").forGetter(CosmeticData::flatModel), (App)ResourceLocation.f_135803_.optionalFieldOf("texture").forGetter(CosmeticData::texture), (App)ResourceLocation.f_135803_.optionalFieldOf("flatTexture").forGetter(CosmeticData::flatTexture)).apply((Applicative)instance, CosmeticData::new));
    public static final ResourceLocation COMMON_COSTUME = new ResourceLocation("umapyoi", "common_costume");
    public static final CosmeticData DEFAULT_COSTUME = new CosmeticData(COMMON_COSTUME);
    public static final ResourceKey<Registry<CosmeticData>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("umapyoi", "cosmetic_data"));

    public CosmeticData(ResourceLocation model) {
        this(model, Optional.of(model), Optional.of(model), Optional.of(model));
    }

    public CosmeticData(ResourceLocation model, ResourceLocation texture) {
        this(model, Optional.of(model), Optional.of(texture), Optional.of(texture));
    }

    public CosmeticData(ResourceLocation model, ResourceLocation flatModel, ResourceLocation texture, ResourceLocation flatTexture) {
        this(model, Optional.of(flatModel), Optional.of(texture), Optional.of(flatTexture));
    }

    public ResourceLocation getFlatModel() {
        return this.flatModel.orElse(this.model);
    }

    public ResourceLocation getTexture(boolean tanned) {
        ResourceLocation result = this.texture.orElse(this.model);
        if (tanned) {
            result = new ResourceLocation(result.m_135827_(), result.m_135815_() + "_tanned");
        }
        return ClientUtils.getTexture(result);
    }

    public ResourceLocation getFlatTexture(boolean tanned) {
        ResourceLocation result = this.flatTexture.orElse(this.texture.orElse(this.model));
        if (tanned) {
            result = new ResourceLocation(result.m_135827_(), result.m_135815_() + "_tanned");
        }
        return ClientUtils.getTexture(result);
    }
}

