/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class WhiteStatusFactor
extends UmaFactor {
    private final UmaStatusUtils.StatusType statusType;

    public WhiteStatusFactor(UmaStatusUtils.StatusType status) {
        super(FactorType.OTHER);
        this.statusType = status;
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        int roll;
        int statusLevel = stack.getLevel();
        int maxStatusLevel = stack.getLevel();
        double chance = (double)stack.getLevel() * 0.25;
        Random rand = new Random();
        for (roll = 0; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --maxStatusLevel;
        }
        int[] nArray = UmaSoulUtils.getMaxProperty(soul);
        int n = this.statusType.getId();
        nArray[n] = nArray[n] + maxStatusLevel;
        for (roll = 0; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --statusLevel;
        }
        int[] nArray2 = UmaSoulUtils.getProperty(soul);
        int n2 = this.statusType.getId();
        nArray2[n2] = nArray2[n2] + Math.min(maxStatusLevel, statusLevel + stack.getLevel());
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        return this.getFullDescription(stack.getLevel());
    }
}

