/*
 * Decompiled with CFR 0.152.
 */
package net.cebularz.newandmuddy.block.custom;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.cebularz.newandmuddy.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="newandmuddy")
public class MudFarmLand
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public MudFarmLand(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return !this.m_49966_().m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) ? Blocks.f_220864_.m_49966_() : super.m_5573_(pContext);
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            MudFarmLand.turnToDirt(null, pState, (Level)pLevel, pPos);
        }
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (!pLevel.f_46443_ && ForgeHooks.onFarmlandTrample((Level)pLevel, (BlockPos)pPos, (BlockState)Blocks.f_220864_.m_49966_(), (float)pFallDistance, (Entity)pEntity)) {
            MudFarmLand.turnToDirt(pEntity, pState, pLevel, pPos);
        }
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public static void turnToDirt(@Nullable Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = MudFarmLand.m_49897_((BlockState)pState, (BlockState)Blocks.f_220864_.m_49966_(), (LevelAccessor)pLevel, (BlockPos)pPos);
        pLevel.m_46597_(pPos, blockstate);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter pLevel, BlockPos pPos) {
        BlockState plant = pLevel.m_8055_(pPos.m_7494_());
        BlockState state = pLevel.m_8055_(pPos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(pLevel, pPos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (!(pEntity instanceof ItemEntity) && !pEntity.m_6144_()) {
            for (int i = 0; i < 15; ++i) {
                double d0 = (double)pPos.m_123341_() + pLevel.m_213780_().m_188500_();
                double d1 = (double)pPos.m_123342_() + pLevel.m_213780_().m_188500_();
                double d2 = (double)pPos.m_123343_() + pLevel.m_213780_().m_188500_();
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220864_.m_49966_());
                pLevel.m_7106_((ParticleOptions)blockParticleData, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            MudFarmLand.turnToDirt(pEntity, pState, pLevel, pPos);
            super.m_141947_(pLevel, pPos, pState, pEntity);
        }
    }

    private static boolean isNearWater(LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos;
        BlockState state = pLevel.m_8055_(pPos);
        Iterator var3 = BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, 0, -4), (BlockPos)pPos.m_7918_(4, 1, 4)).iterator();
        do {
            if (var3.hasNext()) continue;
            return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)pLevel, (BlockPos)pPos);
        } while (!state.canBeHydrated((BlockGetter)pLevel, pPos, pLevel.m_6425_(blockpos = (BlockPos)var3.next()), blockpos));
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @SubscribeEvent
    public static void mudfarmlandmake(BlockEvent.BlockToolModificationEvent event) {
        if (event.isCanceled() || !event.getToolAction().equals(ToolActions.HOE_TILL)) {
            return;
        }
        Level world = event.getContext().m_43725_();
        BlockPos pos = event.getPos();
        BlockState farmblock = world.m_8055_(event.getContext().m_8083_());
        BlockState newBlock = ((Block)ModBlocks.MUD_FARMLAND.get()).m_49966_();
        if (event.getToolAction() == ToolActions.HOE_TILL && farmblock.m_60713_(Blocks.f_220864_) && newBlock.m_60710_((LevelReader)world, pos)) {
            event.setFinalState(((Block)ModBlocks.MUD_FARMLAND.get()).m_49966_());
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pLevel.m_6042_().f_63857_()) {
            pLevel.m_7731_(pPos, ((Block)ModBlocks.DRIED_MUD.get()).m_49966_(), 3);
            pLevel.m_46796_(2009, pPos, 0);
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (1.0f + pLevel.m_213780_().m_188501_() * 0.2f) * 0.7f);
        }
    }
}

