/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ObsidanAxe
extends AxeItem {
    private static final TagKey<Block> MINEABLE_LOGS_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "logs"));
    private static final TagKey<Block> MINEABLE_LEAVES_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "leaves"));
    private boolean activated = false;
    private long lastActivationTime = 0L;
    private static final long COOLDOWN_DURATION = 800L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanAxe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.activated && world.m_46467_() - this.lastActivationTime >= 100L && entity instanceof Player) {
            this.deactivate((Player)entity);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        long currentTime = worldIn.m_46467_();
        if (!this.activated && currentTime - this.lastActivationTime >= 800L) {
            if (!worldIn.f_46443_) {
                this.activate();
                this.lastActivationTime = currentTime;
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.axe").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate(Player player) {
        this.activated = false;
        player.m_36335_().m_41524_((Item)this, 800);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        Block block;
        if (!world.f_46443_ && this.activated && entity instanceof Player && ((block = state.m_60734_()).m_49966_().m_204336_(MINEABLE_LOGS_TAG) || block.m_49966_().m_204336_(MINEABLE_LEAVES_TAG))) {
            this.chainBreak(world, pos, (Player)entity, stack);
            this.deactivate((Player)entity);
            return true;
        }
        return super.m_6813_(stack, world, state, pos, entity);
    }

    private void chainBreak(Level world, BlockPos pos, Player player, ItemStack stack) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        AtomicInteger blockBreakCount = new AtomicInteger(0);
        queue.offer(pos);
        visited.add(pos);
        while (!queue.isEmpty() && blockBreakCount.get() < 300) {
            BlockPos currentPos = (BlockPos)queue.poll();
            this.breakBlock(world, currentPos, player, stack, visited, queue, blockBreakCount);
        }
    }

    private void breakBlock(Level world, BlockPos pos, Player player, ItemStack stack, Set<BlockPos> visited, Queue<BlockPos> queue, AtomicInteger blockBreakCount) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block.m_49966_().m_204336_(MINEABLE_LOGS_TAG) || block.m_49966_().m_204336_(MINEABLE_LEAVES_TAG) || block == Blocks.f_50451_ || block == Blocks.f_50692_ || block == Blocks.f_50701_) {
            world.m_46961_(pos, true);
            blockBreakCount.incrementAndGet();
            for (BlockPos offset : this.getNeighbors(pos)) {
                if (visited.contains(offset)) continue;
                visited.add(offset);
                queue.offer(offset);
            }
        }
    }

    private Iterable<BlockPos> getNeighbors(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    neighbors.add(pos.m_7918_(dx, dy, dz));
                }
            }
        }
        return neighbors;
    }
}

