/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ObsidanSword
extends SwordItem {
    private boolean activated = false;
    private long lastActivationTime = 0L;
    private static final long COOLDOWN_DURATION = 1600L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.activated && world.m_46467_() - this.lastActivationTime >= 100L) {
            this.deactivate((Player)entity);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        long currentTime = worldIn.m_46467_();
        if (!this.activated && currentTime - this.lastActivationTime >= 1600L) {
            if (!worldIn.f_46443_) {
                this.activate();
                this.lastActivationTime = currentTime;
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.sword").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void activate() {
        this.activated = true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_7578_() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (stack.m_41720_() instanceof ObsidanSword) {
                ObsidanSword sword = (ObsidanSword)stack.m_41720_();
                if (sword.activated) {
                    float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
                    float additionalDamage = 1.5f;
                    livingEntity.m_6469_(new DamageSource((Holder)player.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_)), baseDamage * additionalDamage);
                    sword.deactivate(player);
                    return true;
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void deactivate(Player player) {
        this.activated = false;
        player.m_36335_().m_41524_((Item)this, 1600);
    }
}

