/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.item.ItemsObs;
import net.rezolv.obsidanum.sound.SoundsObs;

public class ObsidianDoor
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final BooleanProperty ACTIVE_1 = BooleanProperty.m_61465_((String)"active_1");
    public static final BooleanProperty ACTIVE_2 = BooleanProperty.m_61465_((String)"active_2");
    public static final BooleanProperty ACTIVE_3 = BooleanProperty.m_61465_((String)"active_3");
    public static final BooleanProperty ACTIVE_4 = BooleanProperty.m_61465_((String)"active_4");
    public static final BooleanProperty ACTIVE_TOP = BooleanProperty.m_61465_((String)"active_top");
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public ObsidianDoor(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.CENTER))).m_61124_((Property)ACTIVE_1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : super.m_5939_(state, world, pos, context);
    }

    public boolean m_180643_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)OPEN) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART, ACTIVE_1, ACTIVE_2, ACTIVE_3, ACTIVE_4, ACTIVE_TOP, OPEN});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos partPos = this.getPartPos(pos, facing, x, y);
                    BlockState partState = level.m_8055_(partPos);
                    if (partState.m_60734_() != this) continue;
                    level.m_46961_(partPos, false);
                }
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                BlockPos partPos = this.getPartPos(pos, facing, x, y);
                Part part = Part.getPart(x, y);
                BlockState partState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)ACTIVE_1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
                level.m_7731_(partPos, partState, 3);
                level.m_7260_(partPos, partState, partState, 3);
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)Part.CENTER))).m_61124_((Property)ACTIVE_1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_4, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    private BlockPos getPartPos(BlockPos pos, Direction facing, int x, int y) {
        switch (facing) {
            case NORTH: {
                return pos.m_7918_(x, y, 0);
            }
            case SOUTH: {
                return pos.m_7918_(-x, y, 0);
            }
            case EAST: {
                return pos.m_7918_(0, y, x);
            }
            case WEST: {
                return pos.m_7918_(0, y, -x);
            }
        }
        return pos;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(PART) == Part.CENTER) {
            if (!((Boolean)state.m_61143_((Property)ACTIVE_1)).booleanValue() && player.m_21120_(hand).m_41720_() == ItemsObs.OBSIDIAN_DOOR_KEY_1.get()) {
                Direction facing;
                BlockPos topCenterPos;
                BlockState topCenterState;
                world.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE_1, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (((Boolean)state.m_61143_((Property)ACTIVE_4)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_2)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_3)).booleanValue() && (topCenterState = world.m_8055_(topCenterPos = this.getPartPos(pos, facing = (Direction)state.m_61143_((Property)FACING), 0, 1))).m_60734_() == this && topCenterState.m_61143_(PART) == Part.TOP_CENTER && !((Boolean)topCenterState.m_61143_((Property)ACTIVE_TOP)).booleanValue()) {
                    world.m_7731_(topCenterPos, (BlockState)topCenterState.m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_5594_(null, topCenterPos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)state.m_61143_((Property)ACTIVE_2)).booleanValue() && player.m_21120_(hand).m_41720_() == ItemsObs.OBSIDIAN_DOOR_KEY_2.get()) {
                Direction facing;
                BlockPos topCenterPos;
                BlockState topCenterState;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE_2, (Comparable)Boolean.valueOf(true)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (((Boolean)state.m_61143_((Property)ACTIVE_1)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_3)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_4)).booleanValue() && (topCenterState = world.m_8055_(topCenterPos = this.getPartPos(pos, facing = (Direction)state.m_61143_((Property)FACING), 0, 1))).m_60734_() == this && topCenterState.m_61143_(PART) == Part.TOP_CENTER && !((Boolean)topCenterState.m_61143_((Property)ACTIVE_TOP)).booleanValue()) {
                    world.m_7731_(topCenterPos, (BlockState)topCenterState.m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_5594_(null, topCenterPos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)state.m_61143_((Property)ACTIVE_3)).booleanValue() && player.m_21120_(hand).m_41720_() == ItemsObs.OBSIDIAN_DOOR_KEY_3.get()) {
                Direction facing;
                BlockPos topCenterPos;
                BlockState topCenterState;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE_3, (Comparable)Boolean.valueOf(true)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (((Boolean)state.m_61143_((Property)ACTIVE_1)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_2)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_4)).booleanValue() && (topCenterState = world.m_8055_(topCenterPos = this.getPartPos(pos, facing = (Direction)state.m_61143_((Property)FACING), 0, 1))).m_60734_() == this && topCenterState.m_61143_(PART) == Part.TOP_CENTER && !((Boolean)topCenterState.m_61143_((Property)ACTIVE_TOP)).booleanValue()) {
                    world.m_7731_(topCenterPos, (BlockState)topCenterState.m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_5594_(null, topCenterPos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (!((Boolean)state.m_61143_((Property)ACTIVE_4)).booleanValue() && player.m_21120_(hand).m_41720_() == ItemsObs.OBSIDIAN_DOOR_KEY_4.get()) {
                Direction facing;
                BlockPos topCenterPos;
                BlockState topCenterState;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE_4, (Comparable)Boolean.valueOf(true)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (((Boolean)state.m_61143_((Property)ACTIVE_1)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_2)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_3)).booleanValue() && (topCenterState = world.m_8055_(topCenterPos = this.getPartPos(pos, facing = (Direction)state.m_61143_((Property)FACING), 0, 1))).m_60734_() == this && topCenterState.m_61143_(PART) == Part.TOP_CENTER && !((Boolean)topCenterState.m_61143_((Property)ACTIVE_TOP)).booleanValue()) {
                    world.m_7731_(topCenterPos, (BlockState)topCenterState.m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_5594_(null, topCenterPos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)ACTIVE_1)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_2)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_3)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE_4)).booleanValue()) {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                BlockPos topCenterPos = this.getPartPos(pos, facing, 0, 1);
                BlockState topCenterState = world.m_8055_(topCenterPos);
                if (topCenterState.m_60734_() == this && topCenterState.m_61143_(PART) == Part.TOP_CENTER && !((Boolean)topCenterState.m_61143_((Property)ACTIVE_TOP)).booleanValue()) {
                    world.m_7731_(topCenterPos, (BlockState)topCenterState.m_61124_((Property)ACTIVE_TOP, (Comparable)Boolean.valueOf(true)), 3);
                    world.m_5594_(null, topCenterPos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        BlockPos partPos = this.getPartPos(pos, facing, x, y);
                        BlockState partState = world.m_8055_(partPos);
                        if (partState.m_60734_() != this) continue;
                        BlockState newState = (BlockState)partState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!isOpen));
                        world.m_7731_(partPos, newState, 3);
                    }
                }
                SoundEvent soundEvent = isOpen ? (SoundEvent)SoundsObs.CLOSE_OBSIDIAN_DOOR.get() : (SoundEvent)SoundsObs.OPEN_OBSIDIAN_DOOR.get();
                world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_RIGHT,
        BOTTOM_CENTER,
        BOTTOM_LEFT,
        CENTER_RIGHT,
        CENTER,
        CENTER_LEFT,
        TOP_RIGHT,
        TOP_CENTER,
        TOP_LEFT;


        public static Part getPart(int x, int y) {
            if (x == -1 && y == -1) {
                return BOTTOM_RIGHT;
            }
            if (x == 0 && y == -1) {
                return BOTTOM_CENTER;
            }
            if (x == 1 && y == -1) {
                return BOTTOM_LEFT;
            }
            if (x == -1 && y == 0) {
                return CENTER_RIGHT;
            }
            if (x == 0 && y == 0) {
                return CENTER;
            }
            if (x == 1 && y == 0) {
                return CENTER_LEFT;
            }
            if (x == -1 && y == 1) {
                return TOP_RIGHT;
            }
            if (x == 0 && y == 1) {
                return TOP_CENTER;
            }
            if (x == 1 && y == 1) {
                return TOP_LEFT;
            }
            return CENTER;
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

