/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ObsidanPickaxe
extends PickaxeItem {
    private boolean activated = false;
    private long lastActivationTime = 0L;
    private static final long COOLDOWN_DURATION = 2400L;
    private static final long ACTIVATION_DURATION = 100L;
    private static final Block[] INSTANT_BREAK_BLOCKS = new Block[]{Blocks.f_50069_, Blocks.f_50652_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_50334_, Blocks.f_152550_, Blocks.f_152551_};

    public ObsidanPickaxe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.activated && world.m_46467_() - this.lastActivationTime >= 100L) {
            this.deactivate((Player)entity);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        long currentTime = worldIn.m_46467_();
        ItemStack itemStack = playerIn.m_21120_(handIn);
        if (!this.activated && currentTime - this.lastActivationTime >= 2400L) {
            if (!worldIn.f_46443_) {
                this.activate(playerIn);
                this.lastActivationTime = currentTime;
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        Block block;
        if (!pLevel.f_46443_ && this.activated && this.isInstantBreakBlock(block = pState.m_60734_())) {
            pLevel.m_46961_(pPos, false);
            if (pLevel.f_46441_.m_188501_() < 0.15f) {
                ItemStack diamond = new ItemStack((ItemLike)Items.f_42415_);
                Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)diamond);
            }
            this.deactivate((Player)pEntityLiving);
        }
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.pickaxe").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void activate(Player player) {
        this.activated = true;
    }

    public void deactivate(Player player) {
        this.activated = false;
        player.m_36335_().m_41524_((Item)this, 2400);
    }

    private boolean isInstantBreakBlock(Block block) {
        for (Block instantBreakBlock : INSTANT_BREAK_BLOCKS) {
            if (block != instantBreakBlock) continue;
            return true;
        }
        return false;
    }
}

