/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.item.ItemsObs;

public class GloomyMycelium
extends Block {
    public static final IntegerProperty GROWTH_STAGE = IntegerProperty.m_61631_((String)"growth_stage", (int)0, (int)1);
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public GloomyMycelium(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, GROWTH_STAGE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockBelow = pos.m_121945_(facing.m_122424_());
        return level.m_8055_(blockBelow).m_60783_((BlockGetter)level, blockBelow, facing);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int growthStage = (Integer)pState.m_61143_((Property)GROWTH_STAGE);
        if (pLevel.m_46461_() && pLevel.m_45527_(pPos)) {
            if (growthStage == 0) {
                pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (growthStage == 1) {
                BlockState newState = (BlockState)pState.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(0));
                pLevel.m_7731_(pPos, newState, 3);
                pLevel.m_5594_(null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            }
        } else if (growthStage == 0 && (double)pRandom.m_188501_() < 0.04) {
            BlockState newState = (BlockState)pState.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(1));
            pLevel.m_7731_(pPos, newState, 3);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return (Integer)state.m_61143_((Property)GROWTH_STAGE) < 1 && super.m_6864_(state, context);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return (Integer)state.m_61143_((Property)GROWTH_STAGE) < 1;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && itemStack.m_41720_() == Items.f_42499_ && !level.f_46443_) {
            int randomChance = ((ServerLevel)level).m_213780_().m_188503_(100);
            BlockState newState = state;
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            int growthStage = (Integer)state.m_61143_((Property)GROWTH_STAGE);
            if (growthStage < 1) {
                if (randomChance < 10) {
                    newState = (BlockState)state.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(growthStage + 1));
                }
                level.m_7731_(pos, newState, 2);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                level.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (hand == InteractionHand.MAIN_HAND && itemStack.m_41720_() == Items.f_42574_) {
            int growthStage;
            if (!level.f_46443_ && (growthStage = ((Integer)state.m_61143_((Property)GROWTH_STAGE)).intValue()) == 1) {
                BlockState newState = (BlockState)state.m_61124_((Property)GROWTH_STAGE, (Comparable)Integer.valueOf(0));
                level.m_7731_(pos, newState, 2);
                ItemStack mushroomStack = new ItemStack((ItemLike)ItemsObs.GLOOMY_MUSHROOM.get());
                ItemEntity mushroomEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, mushroomStack);
                level.m_7967_((Entity)mushroomEntity);
                itemStack.m_41622_(1, (LivingEntity)player, p_220037_ -> p_220037_.m_21190_(hand));
                level.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        int growthStage = (Integer)state.m_61143_((Property)GROWTH_STAGE);
        double verticalOffset = growthStage == 1 ? 12.0 : 0.0;
        double horizontalOffset = growthStage == 1 ? 7.0 : 0.0;
        switch (direction) {
            case UP: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(1.0 + verticalOffset), (double)16.0);
            }
            case DOWN: {
                return Block.m_49796_((double)0.0, (double)(15.0 - verticalOffset), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case SOUTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)(1.0 + horizontalOffset));
            }
            case NORTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)(15.0 - horizontalOffset), (double)16.0, (double)16.0, (double)16.0);
            }
            case EAST: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)(1.0 + horizontalOffset), (double)16.0, (double)16.0);
            }
            case WEST: {
                return Block.m_49796_((double)(15.0 - horizontalOffset), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
        }
        return Block.m_49796_((double)0.0, (double)(15.0 - verticalOffset), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

